/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class ProjectNaturesPage
extends PropertyPage {
    private IProject project;
    private List<String> naturesIdsWorkingCopy;
    private TableViewer activeNaturesList;
    private boolean warningAlreadyShown = false;

    public ProjectNaturesPage() {
        this.setDescription(IDEWorkbenchMessages.ProjectNaturesPage_label);
    }

    protected Control createContents(final Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.project_natures_property_page_context");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.initialize();
        Composite header = new Composite(composite, 0);
        header.setLayoutData((Object)new GridData(768));
        header.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 10, 0).spacing(10, 0).create());
        Label warningImageLabel = new Label(header, 0);
        warningImageLabel.setImage(header.getDisplay().getSystemImage(8));
        Label warningLabel = new Label(header, 64);
        warningLabel.setText(IDEWorkbenchMessages.ProjectNaturesPage_warningMessage);
        GridData warningMessageLayoutData = new GridData(4, 0x1000000, true, false);
        warningMessageLayoutData.widthHint = 400;
        warningLabel.setLayoutData((Object)warningMessageLayoutData);
        Composite naturesComposite = new Composite(composite, 0);
        naturesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        naturesComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.activeNaturesList = new TableViewer(naturesComposite);
        this.activeNaturesList.getTable().setFont(font);
        this.activeNaturesList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.activeNaturesList.setLabelProvider((IBaseLabelProvider)new NatureLabelProvider(this.project.getWorkspace()));
        this.activeNaturesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        try {
            this.naturesIdsWorkingCopy = new ArrayList<String>();
            this.naturesIdsWorkingCopy.addAll(Arrays.asList(this.project.getDescription().getNatureIds()));
        }
        catch (CoreException ex) {
            IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(2, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), "Error while loading project description for " + this.project.getName(), (Throwable)ex));
        }
        this.activeNaturesList.setInput(this.naturesIdsWorkingCopy);
        Composite buttonComposite = new Composite(naturesComposite, 0);
        buttonComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.setText(IDEWorkbenchMessages.ProjectNaturesPage_addNature);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProjectNaturesPage.this.warningAlreadyShown) {
                    if (!MessageDialog.openConfirm((Shell)ProjectNaturesPage.this.getShell(), (String)IDEWorkbenchMessages.ProjectNaturesPage_changeWarningTitle, (String)(IDEWorkbenchMessages.ProjectNaturesPage_warningMessage + "\n\n" + IDEWorkbenchMessages.ProjectNaturesPage_changeWarningQuestion))) {
                        return;
                    }
                    ProjectNaturesPage.this.warningAlreadyShown = true;
                }
                ElementListSelectionDialog naturesSelectionDialog = new ElementListSelectionDialog(parent.getShell(), (ILabelProvider)new NatureLabelProvider(ProjectNaturesPage.this.project.getWorkspace()));
                naturesSelectionDialog.setMessage(IDEWorkbenchMessages.ProjectNaturesPage_selectNatureToAddMessage);
                naturesSelectionDialog.setTitle(IDEWorkbenchMessages.ProjectNaturesPage_selectNatureToAddTitle);
                ArrayList<IProjectNatureDescriptor> natures = new ArrayList<IProjectNatureDescriptor>();
                Object[] objectArray = ProjectNaturesPage.this.project.getWorkspace().getNatureDescriptors();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectNatureDescriptor nature = objectArray[n2];
                    if (!ProjectNaturesPage.this.naturesIdsWorkingCopy.contains(nature.getNatureId())) {
                        natures.add(nature);
                    }
                    ++n2;
                }
                naturesSelectionDialog.setElements((Object[])natures.toArray(new IProjectNatureDescriptor[natures.size()]));
                if (naturesSelectionDialog.open() == 0) {
                    objectArray = naturesSelectionDialog.getResult();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IProjectNatureDescriptor item;
                        IProjectNatureDescriptor nature = item = objectArray[n2];
                        ProjectNaturesPage.this.naturesIdsWorkingCopy.add(nature.getNatureId());
                        ++n2;
                    }
                    ProjectNaturesPage.this.activeNaturesList.refresh();
                }
            }
        });
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        removeButton.setText(IDEWorkbenchMessages.ProjectNaturesPage_removeNature);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProjectNaturesPage.this.warningAlreadyShown) {
                    if (!MessageDialog.openConfirm((Shell)ProjectNaturesPage.this.getShell(), (String)IDEWorkbenchMessages.ProjectNaturesPage_changeWarningTitle, (String)(IDEWorkbenchMessages.ProjectNaturesPage_warningMessage + "\n\n" + IDEWorkbenchMessages.ProjectNaturesPage_changeWarningQuestion))) {
                        return;
                    }
                    ProjectNaturesPage.this.warningAlreadyShown = true;
                }
                IStructuredSelection selection = ProjectNaturesPage.this.activeNaturesList.getStructuredSelection();
                for (Object item : selection) {
                    String natureId = (String)item;
                    ProjectNaturesPage.this.naturesIdsWorkingCopy.remove(natureId);
                }
                ProjectNaturesPage.this.activeNaturesList.refresh();
            }
        });
        this.activeNaturesList.addSelectionChangedListener(event -> removeButton.setEnabled(!this.activeNaturesList.getSelection().isEmpty()));
        this.activeNaturesList.setSelection((ISelection)new StructuredSelection());
        return composite;
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = IDEWorkbenchMessages.Internal_error;
            }
            error = new Status(4, "org.eclipse.ui.ide", 1, msg, target);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), null, null, (IStatus)error);
    }

    private void initialize() {
        this.project = (IProject)Adapters.adapt((Object)this.getElement(), IProject.class);
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        List<String> originalNatureIds = null;
        try {
            originalNatureIds = Arrays.asList(this.project.getDescription().getNatureIds());
        }
        catch (CoreException ex) {
            IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(2, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), "Error while loading project description for " + this.project.getName(), (Throwable)ex));
            originalNatureIds = new ArrayList<String>();
        }
        if (this.naturesIdsWorkingCopy.size() == originalNatureIds.size() && this.naturesIdsWorkingCopy.containsAll(originalNatureIds)) {
            return true;
        }
        IRunnableWithProgress runnable = monitor -> {
            try {
                IProjectDescription description = this.project.getDescription();
                description.setNatureIds(this.naturesIdsWorkingCopy.toArray(new String[this.naturesIdsWorkingCopy.size()]));
                this.project.setDescription(description, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return false;
        }
        return true;
    }

    private static class NatureLabelProvider
    extends LabelProvider {
        private IWorkspace workspace;
        private Map<String, Image> natureImages;

        public NatureLabelProvider(IWorkspace workspace) {
            this.workspace = workspace;
            this.natureImages = new HashMap<String, Image>(workspace.getNatureDescriptors().length);
        }

        public String getText(Object element) {
            IProjectNatureDescriptor nature = null;
            if (element instanceof IProjectNatureDescriptor) {
                nature = (IProjectNatureDescriptor)element;
            } else if (element instanceof String) {
                String natureId = (String)element;
                nature = this.workspace.getNatureDescriptor(natureId);
                if (nature == null) {
                    return this.getMissingNatureLabel(natureId);
                }
            } else {
                return "Not a valid nature input " + String.valueOf(element);
            }
            return this.getNatureDescriptorLabel(nature);
        }

        public Image getImage(Object element) {
            String natureId = null;
            if (element instanceof IProjectNatureDescriptor) {
                natureId = ((IProjectNatureDescriptor)element).getNatureId();
            } else if (element instanceof String) {
                natureId = (String)element;
            } else {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            if (this.workspace.getNatureDescriptor(natureId) != null) {
                ImageDescriptor image;
                if (!this.natureImages.containsKey(natureId) && (image = IDEWorkbenchPlugin.getDefault().getProjectImageRegistry().getNatureImage(natureId)) != null) {
                    this.natureImages.put(natureId, image.createImage());
                }
                return this.natureImages.get(natureId);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }

        protected String getMissingNatureLabel(String natureId) {
            return NLS.bind((String)IDEWorkbenchMessages.ProjectNaturesPage_missingNatureText, (Object)natureId);
        }

        protected String getNatureDescriptorLabel(IProjectNatureDescriptor natureDescriptor) {
            String label = natureDescriptor.getLabel();
            if (label.trim().isEmpty()) {
                return natureDescriptor.getNatureId();
            }
            return label;
        }

        public void dispose() {
            for (Image image : this.natureImages.values()) {
                image.dispose();
            }
            super.dispose();
        }
    }
}

