/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.document;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.contentassist.WhitespaceHelper;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;

public class DocumentRewriter {
    private IXtextDocument document;
    private XtextResource resource;
    private List<Section> sections;
    private RewritableImportSection importSection;
    private Factory factory;
    private String indentString;
    private String lineSeparator;

    protected DocumentRewriter(IXtextDocument document, XtextResource resource, Factory factory) {
        this.document = document;
        this.resource = resource;
        this.importSection = factory.rewritableImportSectionFactory.parse(resource);
        this.importSection.setSort(true);
        this.indentString = factory.whitespaceInformationProvider.getIndentationInformation(resource.getURI()).getIndentString();
        this.lineSeparator = factory.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
        this.factory = factory;
        this.sections = Lists.newArrayList();
    }

    public IXtextDocument getDocument() {
        return this.document;
    }

    protected RewritableImportSection getImportSection() {
        return this.importSection;
    }

    public List<ReplaceRegion> getChanges() {
        ArrayList changes = Lists.newArrayList();
        for (Section section : this.sections) {
            ReplaceRegion change = section.getChange();
            changes.add(change);
        }
        for (ReplaceRegion change : this.importSection.rewrite()) {
            changes.add(change);
        }
        return changes;
    }

    public Section newSection(int offset, int length) {
        DocumentSourceAppender.Factory.OptionalParameters parameters = this.createOptionalParameters();
        Section section = (Section)this.factory.sectionFactory.create(this.document, this.resource, offset, length, parameters);
        this.addSection(section);
        return section;
    }

    public Section newSection(int offset, int length, boolean ensureEmptyLinesAround) {
        DocumentSourceAppender.Factory.OptionalParameters parameters = this.createOptionalParameters();
        parameters.ensureEmptyLinesAround = ensureEmptyLinesAround;
        Section section = (Section)this.factory.sectionFactory.create(this.document, this.resource, offset, length, parameters);
        this.addSection(section);
        return section;
    }

    public Section newSection(int offset, int length, int baseIndentationLevel, boolean ensureEmptyLinesAround) {
        DocumentSourceAppender.Factory.OptionalParameters parameters = this.createOptionalParameters();
        parameters.ensureEmptyLinesAround = ensureEmptyLinesAround;
        parameters.baseIndentationLevel = baseIndentationLevel;
        Section section = (Section)this.factory.sectionFactory.create(this.document, this.resource, offset, length, parameters);
        this.addSection(section);
        return section;
    }

    protected DocumentSourceAppender.Factory.OptionalParameters createOptionalParameters() {
        DocumentSourceAppender.Factory.OptionalParameters parameters = new DocumentSourceAppender.Factory.OptionalParameters();
        parameters.importSection = this.importSection;
        return parameters;
    }

    protected void addSection(Section newSection) {
        for (Section otherSection : this.sections) {
            if (!newSection.isOverlap(otherSection)) continue;
            throw new IllegalArgumentException("Section overlaps with exisiting section");
        }
        this.sections.add(newSection);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public static class Factory {
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;
        @Inject
        private RewritableImportSection.Factory rewritableImportSectionFactory;
        @Inject
        private Section.Factory sectionFactory;

        public DocumentRewriter create(IXtextDocument document, XtextResource resource) {
            return new DocumentRewriter(document, resource, this);
        }
    }

    public static class Section
    extends DocumentSourceAppender {
        public Section(IXtextDocument document, RewritableImportSection importSection, WhitespaceHelper whitespaceHelper, String indentString, String lineSeparator, int baseIndentationLevel, boolean isJava) {
            super(document, importSection, whitespaceHelper, indentString, lineSeparator, baseIndentationLevel, isJava);
        }

        public boolean isOverlap(Section other) {
            return this.getTotalOffset() == other.getTotalOffset() || this.getTotalOffset() < other.getTotalOffset() + other.getTotalLength() && this.getTotalOffset() + this.getTotalLength() > other.getTotalOffset();
        }

        static class Factory
        extends DocumentSourceAppender.Factory<Section> {
            Factory() {
            }

            @Override
            protected Section newInstance(IXtextDocument document, RewritableImportSection importSection, WhitespaceHelper whitespaceHelper, String indentString, String lineSeparator, int baseIndentationLevel, boolean isJava) {
                return new Section(document, importSection, whitespaceHelper, indentString, lineSeparator, baseIndentationLevel, isJava);
            }
        }
    }
}

