/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityRelationshipFactory
extends AbstractStylingModelFactory {
    public GraphModelEntityRelationshipFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        if (!(viewer.getContentProvider() instanceof IGraphEntityRelationshipContentProvider)) {
            throw new IllegalArgumentException("Expected IGraphEntityRelationshipContentProvider");
        }
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] nodes = this.getContentProvider().getElements(this.getViewer().getInput());
        nodes = this.filter(this.getViewer().getInput(), nodes);
        this.createModelNodes(model, nodes);
        this.createModelRelationships(model);
    }

    private void createModelRelationships(Graph model) {
        GraphNode[] modelNodes = this.getNodesArray(model);
        ArrayList<GraphNode> listOfNodes = new ArrayList<GraphNode>();
        GraphNode[] graphNodeArray = modelNodes;
        int n = modelNodes.length;
        int n2 = 0;
        while (n2 < n) {
            GraphNode modelNode = graphNodeArray[n2];
            listOfNodes.add(modelNode);
            ++n2;
        }
        int i = 0;
        while (i < listOfNodes.size()) {
            GraphNode node = (GraphNode)((Object)listOfNodes.get(i));
            if (node instanceof GraphContainer) {
                List<GraphNode> childNodes = ((GraphContainer)node).getNodes();
                listOfNodes.addAll(childNodes);
            }
            ++i;
        }
        modelNodes = listOfNodes.toArray(new GraphNode[listOfNodes.size()]);
        IGraphEntityRelationshipContentProvider content = this.getCastedContent();
        GraphNode[] graphNodeArray2 = modelNodes;
        int n3 = modelNodes.length;
        n = 0;
        while (n < n3) {
            GraphNode modelNode = graphNodeArray2[n];
            GraphNode[] graphNodeArray3 = modelNodes;
            int n4 = modelNodes.length;
            int n5 = 0;
            while (n5 < n4) {
                GraphNode modelNode2 = graphNodeArray3[n5];
                Object[] rels = content.getRelationships(modelNode.getData(), modelNode2.getData());
                if (rels != null) {
                    Object[] objectArray = rels = this.filter(this.getViewer().getInput(), rels);
                    int n6 = rels.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Object rel = objectArray[n7];
                        this.createConnection(model, rel, modelNode.getData(), modelNode2.getData());
                        ++n7;
                    }
                }
                ++n5;
            }
            ++n;
        }
    }

    private void createModelNodes(Graph model, Object[] nodes) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.createNode(model, node);
            ++n2;
        }
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    @Override
    public void refresh(Graph graph, Object element, boolean updateLabels) {
        this.refreshGraph(graph);
    }

    private IGraphEntityRelationshipContentProvider getCastedContent() {
        return (IGraphEntityRelationshipContentProvider)this.getContentProvider();
    }
}

