/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ContributorAgreement;
import java.sql.Timestamp;

public interface AbstractAgreement {
    public ContributorAgreement.Id getAgreementId();

    public Timestamp getAcceptedOn();

    public Status getStatus();

    public Timestamp getReviewedOn();

    public Account.Id getReviewedBy();

    public String getReviewComments();

    public static enum Status {
        NEW('n'),
        VERIFIED('V'),
        REJECTED('R');

        private final char code;

        private Status(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }
}

