/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.ClangToolChain;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class GCCPathToolChainProvider
implements IToolChainProvider {
    public static final String ID = "org.eclipse.cdt.build.gcc.core.gccPathProvider";
    private static final Pattern gccPattern = Pattern.compile("gcc(\\.exe)?");
    private static final Pattern tupledGccPattern = Pattern.compile("(.*-)?gcc(\\.exe)?");
    private static final Pattern clangPattern = Pattern.compile("clang(\\.exe)?");

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) {
        String path = System.getenv("PATH");
        ArrayList<GCCToolChain> tupledList = new ArrayList<GCCToolChain>();
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block35: {
                String string = stringArray[n2];
                File dir = new File(string);
                if (!dir.isDirectory()) break block35;
                File[] fileArray = dir.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block34: {
                        Matcher matcher;
                        File file;
                        block36: {
                            file = fileArray[n4];
                            if (file.isDirectory()) break block34;
                            matcher = gccPattern.matcher(file.getName());
                            Matcher matcher2 = tupledGccPattern.matcher(file.getName());
                            if (!matcher.matches() && !matcher2.matches()) break block36;
                            try {
                                String[] tuple;
                                GCCToolChain.GCCInfo info = new GCCToolChain.GCCInfo(file.toString());
                                if (info.target == null || info.version == null || (tuple = info.target.split("-")).length <= 2) break block34;
                                GCCToolChain gcc = new GCCToolChain((IToolChainProvider)this, file.toPath(), tuple[0], null);
                                block7 : switch (tuple[1]) {
                                    case "w64": {
                                        gcc.setProperty("os", "win32");
                                        break;
                                    }
                                    case "linux": {
                                        gcc.setProperty("os", "linux");
                                        break;
                                    }
                                    case "apple": {
                                        gcc.setProperty("os", "macosx");
                                        break;
                                    }
                                    default: {
                                        switch (tuple[2]) {
                                            case "linux": {
                                                gcc.setProperty("os", "linux");
                                                break block7;
                                            }
                                            case "elf": {
                                                gcc.setProperty("os", tuple[1]);
                                            }
                                        }
                                    }
                                }
                                try {
                                    if (manager.getToolChain(gcc.getTypeId(), gcc.getId()) == null) {
                                        if (matcher.matches()) {
                                            manager.addToolChain((IToolChain)gcc);
                                        } else {
                                            tupledList.add(gcc);
                                        }
                                    }
                                    break block34;
                                }
                                catch (CoreException e) {
                                    CCorePlugin.log((IStatus)e.getStatus());
                                }
                            }
                            catch (IOException e) {
                                Activator.log(e);
                            }
                            break block34;
                        }
                        matcher = clangPattern.matcher(file.getName());
                        if (matcher.matches()) {
                            ClangToolChain clang = new ClangToolChain((IToolChainProvider)this, file.toPath(), Platform.getOSArch(), null);
                            clang.setProperty("os", Platform.getOS());
                            manager.addToolChain((IToolChain)clang);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (IToolChain iToolChain : tupledList) {
            manager.addToolChain(iToolChain);
        }
    }
}

