/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.debug.internal.ui.pinclone.DebugContextPinProvider;
import org.eclipse.cdt.debug.internal.ui.pinclone.DebugEventFilterService;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;

public class PinDebugContextActionDelegate
implements IViewActionDelegate,
IActionDelegate2,
IDebugContextListener {
    private IViewPart fPart;
    private String fPinnedContextLabel = "";
    private String fLastKnownDescription = "";
    private IAction fAction;
    private IPartListener2 fPartListener;
    private DebugContextPinProvider fProvider;

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (action.isChecked()) {
            this.fProvider = DebugEventFilterService.getInstance().addDebugEventFilter((IWorkbenchPart)this.fPart, this.getActiveDebugContext());
            if (this.fProvider != null) {
                this.fLastKnownDescription = ((WorkbenchPart)this.fPart).getContentDescription();
                this.fPinnedContextLabel = this.getPinContextLabel(this.fProvider);
                PinCloneUtils.setPartContentDescription(this.fPart, this.fPinnedContextLabel);
                this.updatePinContextColor(this.fProvider);
            }
        } else {
            this.fProvider = null;
            DebugEventFilterService.getInstance().removeDebugEventFilter((IWorkbenchPart)this.fPart);
            this.updatePinContextColor(this.fProvider);
            PinCloneUtils.setPartContentDescription(this.fPart, this.fLastKnownDescription);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void init(IViewPart view) {
        this.fPart = view;
        if (this.fAction != null && !this.fAction.isChecked()) {
            IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(this.fPart.getViewSite().getWorkbenchWindow());
            boolean pinnable = PinCloneUtils.isPinnable((IWorkbenchPart)this.fPart, service.getActiveContext());
            this.fAction.setEnabled(pinnable);
        }
        this.fPart.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (261 == propId) {
                    String desc = ((WorkbenchPart)PinDebugContextActionDelegate.this.fPart).getContentDescription();
                    if (!PinDebugContextActionDelegate.this.fPinnedContextLabel.equals(desc)) {
                        PinDebugContextActionDelegate.this.fLastKnownDescription = desc;
                    }
                    if (PinDebugContextActionDelegate.this.fAction != null && PinDebugContextActionDelegate.this.fAction.isChecked()) {
                        PinCloneUtils.setPartContentDescription(PinDebugContextActionDelegate.this.fPart, PinDebugContextActionDelegate.this.fPinnedContextLabel);
                    }
                } else if (260 == propId) {
                    PinCloneUtils.setPartTitle(PinDebugContextActionDelegate.this.fPart);
                }
            }
        });
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.fPart.getSite(), (IDebugContextListener)this);
        this.fPartListener = new IPartListener2(){

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part.equals(PinDebugContextActionDelegate.this.fPart)) {
                    PinDebugContextActionDelegate.this.unpinPart();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        this.fPart.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
    }

    public void dispose() {
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.fPart.getSite(), (IDebugContextListener)this);
        this.fPart.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        this.unpinPart();
    }

    protected void unpinPart() {
        if (this.fAction.isChecked()) {
            DebugEventFilterService.getInstance().removeDebugEventFilter((IWorkbenchPart)this.fPart);
            this.fAction.setChecked(false);
        }
    }

    protected ISelection getActiveDebugContext() {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.fPart.getSite().getWorkbenchWindow());
        return contextService.getActiveContext();
    }

    private String getPinContextLabel(DebugContextPinProvider provider) {
        Object description = "";
        if (provider != null) {
            HashSet<String> labels = new HashSet<String>();
            for (IPinProvider.IPinElementHandle handle : provider.getPinHandles()) {
                String tmp = this.getLabel(handle);
                if (tmp == null || tmp.trim().length() == 0) continue;
                labels.add(tmp);
            }
            for (String label : labels) {
                if (label == null) continue;
                description = ((String)description).length() > 0 ? (String)description + ", " + label : label;
            }
        }
        return description;
    }

    private String getLabel(IPinProvider.IPinElementHandle handle) {
        String label = "";
        if (handle != null) {
            label = handle.getLabel();
        }
        return label;
    }

    private boolean useMultiPinImage(Set<IPinProvider.IPinElementHandle> handles) {
        if (handles.size() <= 1) {
            return false;
        }
        int overlayColor = -1;
        ImageDescriptor imageDesc = null;
        for (IPinProvider.IPinElementHandle handle : handles) {
            IPinProvider.IPinElementColorDescriptor colorDesc = handle.getPinElementColorDescriptor();
            if (colorDesc == null) continue;
            ImageDescriptor descImageDesc = colorDesc.getToolbarIconDescriptor();
            if (imageDesc != null && !imageDesc.equals(descImageDesc)) {
                return true;
            }
            imageDesc = descImageDesc;
            int descOverlayColor = colorDesc.getOverlayColor();
            if (overlayColor != -1 && descOverlayColor != overlayColor) {
                return true;
            }
            overlayColor = descOverlayColor;
        }
        return false;
    }

    private void updatePinContextColor(DebugContextPinProvider provider) {
        ImageDescriptor imageDesc = null;
        if (provider != null) {
            Iterator<IPinProvider.IPinElementHandle> itr;
            Set<IPinProvider.IPinElementHandle> handles = provider.getPinHandles();
            if (this.useMultiPinImage(handles)) {
                imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_multi.gif");
            }
            if (imageDesc == null && (itr = handles.iterator()).hasNext()) {
                IPinProvider.IPinElementHandle handle = itr.next();
                IPinProvider.IPinElementColorDescriptor desc = handle.getPinElementColorDescriptor();
                if (desc != null) {
                    imageDesc = desc.getToolbarIconDescriptor();
                }
                if (imageDesc == null && desc != null) {
                    int overlayColor = desc.getOverlayColor() % 3;
                    switch (overlayColor) {
                        case 0: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_g.gif");
                            break;
                        }
                        case 1: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_r.gif");
                            break;
                        }
                        case 2: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_b.gif");
                        }
                    }
                }
            }
        }
        if (imageDesc == null) {
            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned.gif");
        }
        this.fAction.setImageDescriptor(imageDesc);
    }

    public void debugContextChanged(DebugContextEvent event) {
        boolean pinnable;
        if (this.fAction != null && !this.fAction.isChecked() && (pinnable = PinCloneUtils.isPinnable((IWorkbenchPart)this.fPart, event.getContext())) != this.fAction.isEnabled()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.fAction.setEnabled(pinnable));
        }
    }
}

