/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MiSourceFilesInfo
extends MIInfo {
    private SourceFileInfo[] sourceFileInfos;

    public MiSourceFilesInfo(MIOutput record) {
        super(record);
        this.parse();
        if (this.sourceFileInfos == null) {
            this.sourceFileInfos = new SourceFileInfo[0];
        }
    }

    public SourceFileInfo[] getSourceFiles() {
        return this.sourceFileInfos;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("files") && (value = results[i].getMIValue()) instanceof MIList) {
                    this.parseResults((MIList)value);
                }
                ++i;
            }
        }
    }

    private void parseResults(MIList list) {
        MIValue[] miValues = list.getMIValues();
        LinkedList<SourceFileInfo> infos = new LinkedList<SourceFileInfo>();
        if (miValues != null) {
            MIValue[] mIValueArray = miValues;
            int n = miValues.length;
            int n2 = 0;
            while (n2 < n) {
                MIValue miValue = mIValueArray[n2];
                if (miValue instanceof MITuple) {
                    MITuple miTuple = (MITuple)miValue;
                    SourceFileInfo info = new SourceFileInfo();
                    info.parse(miTuple.getMIResults());
                    infos.add(info);
                }
                ++n2;
            }
        }
        this.sourceFileInfos = infos.toArray(new SourceFileInfo[infos.size()]);
    }

    public static class SourceFileInfo {
        private String file;
        private String fullname;

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }

        public void setFullName(String fullname) {
            this.fullname = fullname;
        }

        public String getFullName() {
            return this.fullname;
        }

        private void parse(MIResult[] results) {
            MIResult[] mIResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    MIResult result = mIResultArray[n2];
                    String variable = result.getVariable();
                    MIValue miVal = result.getMIValue();
                    if (!(miVal instanceof MIConst)) break block11;
                    String value = ((MIConst)miVal).getCString();
                    switch (variable) {
                        case "file": {
                            this.file = value;
                            break;
                        }
                        case "fullname": {
                            this.fullname = value;
                        }
                    }
                }
                ++n2;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.fullname == null ? 0 : this.fullname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceFileInfo other = (SourceFileInfo)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            return !(this.fullname == null ? other.fullname != null : !this.fullname.equals(other.fullname));
        }

        public String toString() {
            return "SourceFileInfo [file=" + this.file + ", fullname=" + this.fullname + "]";
        }
    }
}

