/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescriptionGnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenerateMakefileWithBuildDescription
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)projectHandle);
        if (info == null) {
            throw new ProcessFailureException(ManagedMakeMessages.getString("GenerateMakefileWithBuildDescription.0"));
        }
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            throw new ProcessFailureException(ManagedMakeMessages.getString("GenerateMakefileWithBuildDescription.1"));
        }
        try {
            IBuildDescription des = BuildDescriptionManager.createBuildDescription(cfg, null, 0);
            IFile file = projectHandle.getFile("makefile");
            ByteArrayOutputStream oStream = new ByteArrayOutputStream(100);
            BuildDescriptionGnuMakefileGenerator gen = new BuildDescriptionGnuMakefileGenerator(des);
            gen.store(oStream);
            byte[] bytes = oStream.toByteArray();
            ByteArrayInputStream iStream = new ByteArrayInputStream(bytes);
            if (!file.exists()) {
                file.create((InputStream)iStream, true, monitor);
            } else {
                file.setContents((InputStream)iStream, true, false, monitor);
            }
        }
        catch (CoreException e1) {
            throw new ProcessFailureException((Throwable)e1);
        }
    }
}

