/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.runtime.Path;

public class GnuCygwinConfigurationEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String ENV_PATH = "PATH";
    private static final String ENV_LANG = "LANG";
    private static final String ENV_LC_ALL = "LC_ALL";
    private static final String ENV_LC_MESSAGES = "LC_MESSAGES";
    private static final String PROPERTY_OSNAME = "os.name";
    private static final String BACKSLASH = File.separator;

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName == null) {
            return null;
        }
        if (!System.getProperty(PROPERTY_OSNAME).toLowerCase().startsWith("windows ")) {
            return null;
        }
        if (variableName.equalsIgnoreCase(ENV_PATH)) {
            String path = "${CYGWIN_HOME}" + BACKSLASH + "bin";
            return new BuildEnvVar(ENV_PATH, path, 3);
        }
        if (variableName.equals("CYGWIN_HOME")) {
            IEnvironmentVariable varCygwinHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable("CYGWIN_HOME", null, false);
            if (varCygwinHome == null) {
                String home = Cygwin.getCygwinHome();
                if (home == null) {
                    home = "";
                }
                return new BuildEnvVar("CYGWIN_HOME", new Path(home).toOSString());
            }
            return null;
        }
        if (variableName.equalsIgnoreCase(ENV_LANG)) {
            String langValue = System.getenv(ENV_LANG);
            if (langValue == null || langValue.length() == 0) {
                langValue = System.getenv(ENV_LC_ALL);
            }
            if (langValue == null || langValue.length() == 0) {
                langValue = System.getenv(ENV_LC_MESSAGES);
            }
            langValue = langValue != null && langValue.length() > 0 ? langValue.replaceFirst("([^.@]*)(\\..*)?(@.*)?", "$1.ISO-8859-1") : "C.ISO-8859-1";
            return new BuildEnvVar(ENV_LANG, langValue);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable varHome = this.getVariable("CYGWIN_HOME", configuration, provider);
        IBuildEnvironmentVariable varLang = this.getVariable(ENV_LANG, configuration, provider);
        IBuildEnvironmentVariable varPath = this.getVariable(ENV_PATH, configuration, provider);
        return new IBuildEnvironmentVariable[]{varHome, varLang, varPath};
    }
}

