/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.ScannerHelper;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.search.StringOperation;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.dltk.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.OrPattern;
import org.eclipse.dltk.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;

public abstract class SearchPattern
extends InternalSearchPattern {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;
    public static final int R_ERASURE_MATCH = 16;
    public static final int R_EQUIVALENT_MATCH = 32;
    public static final int R_FULL_MATCH = 64;
    public static final int R_CAMELCASE_MATCH = 128;
    public static final int R_CAMELCASE_SAME_PART_COUNT_MATCH = 256;
    public static final int R_SUBSTRING_MATCH = 512;
    private static final int MODE_MASK = 7;
    private int matchRule;
    private IDLTKLanguageToolkit toolkit;
    private Pattern regexpCompiledPattern;

    public SearchPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        this.matchRule = matchRule;
        this.toolkit = toolkit;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
    }

    public IDLTKLanguageToolkit getToolkit() {
        return this.toolkit;
    }

    public static final boolean camelCaseMatch(String pattern, String name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return SearchPattern.camelCaseMatch(pattern, 0, pattern.length(), name, 0, name.length());
    }

    public static final boolean camelCaseMatch(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name.charAt(nameStart) != pattern.charAt(patternStart)) {
            return false;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        block0: while (true) {
            char nameChar;
            ++iName;
            if (++iPattern == patternEnd) {
                return true;
            }
            if (iName == nameEnd) {
                return false;
            }
            char patternChar = pattern.charAt(iPattern);
            if (patternChar == name.charAt(iName)) continue;
            if (patternChar < '\u0080' ? (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[patternChar] & 0x20) == 0 : Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar)) {
                return false;
            }
            while (true) {
                if (iName == nameEnd) {
                    return false;
                }
                nameChar = name.charAt(iName);
                if (nameChar < '\u0080') {
                    if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 0x94) != 0) {
                        ++iName;
                        continue;
                    }
                    if (patternChar == nameChar) continue block0;
                    return false;
                }
                if (!Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) break;
                ++iName;
            }
            if (patternChar != nameChar) break;
        }
        return false;
    }

    public static SearchPattern createAndPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return null;
    }

    private static SearchPattern createFieldPattern(String patternString, int limitTo, int matchRule, IDLTKLanguageToolkit toolkit) {
        char[] declaringTypeSignature = null;
        boolean findDeclarations = true;
        boolean findReferences = true;
        switch (limitTo) {
            case 0: {
                findReferences = false;
                break;
            }
            case 1: {
                findDeclarations = false;
                break;
            }
        }
        char[] selectorChars = patternString.toCharArray();
        char[] declaringTypeQualification = null;
        char[] declaringTypeSimpleName = null;
        return new FieldPattern(findDeclarations, findReferences, findReferences, selectorChars, declaringTypeQualification, declaringTypeSimpleName, declaringTypeSignature, null, matchRule, toolkit);
    }

    private static SearchPattern createMethodOrConstructorPattern(String patternString, int limitTo, int matchRule, boolean isConstructor, IDLTKLanguageToolkit toolkit) {
        char[] selectorChars;
        String declaringTypeSignature = null;
        char[] declaringTypeQualification = null;
        char[] declaringTypeSimpleName = null;
        ISearchPatternProcessor processor = DLTKLanguageManager.getSearchPatternProcessor(toolkit);
        if (processor != null) {
            declaringTypeQualification = processor.extractDeclaringTypeQualification(patternString);
            declaringTypeSimpleName = processor.extractDeclaringTypeSimpleName(patternString);
            selectorChars = processor.extractSelector(patternString);
        } else {
            selectorChars = patternString.toCharArray();
        }
        boolean findDeclarations = true;
        boolean findReferences = true;
        switch (limitTo) {
            case 0: {
                findReferences = false;
                break;
            }
            case 1: {
                findDeclarations = false;
                break;
            }
        }
        if (!isConstructor) {
            MethodDeclarationPattern declarationPattern = null;
            MethodPattern referencesPattern = null;
            if (findDeclarations) {
                char[][] enclosingTypes;
                char[][] packageNames = declaringTypeQualification != null ? CharOperation.splitOn(processor.getDelimiterReplacementString().toCharArray(), declaringTypeQualification) : CharOperation.NO_CHAR_CHAR;
                int enclosingTypeCount = packageNames.length;
                if (declaringTypeSimpleName != null) {
                    ++enclosingTypeCount;
                }
                if (enclosingTypeCount != 0) {
                    enclosingTypes = new char[enclosingTypeCount][];
                    System.arraycopy(packageNames, 0, enclosingTypes, 0, packageNames.length);
                    if (declaringTypeSimpleName != null) {
                        enclosingTypes[enclosingTypeCount - 1] = declaringTypeSimpleName;
                    }
                } else {
                    enclosingTypes = null;
                }
                declarationPattern = new MethodDeclarationPattern(enclosingTypes, selectorChars, matchRule, toolkit);
            }
            if (findReferences) {
                referencesPattern = new MethodPattern(findDeclarations, findReferences, selectorChars, declaringTypeQualification, declaringTypeSimpleName, declaringTypeSignature, null, matchRule, toolkit);
            }
            if (findDeclarations) {
                if (findReferences) {
                    return new OrPattern(declarationPattern, referencesPattern);
                }
                return declarationPattern;
            }
            return referencesPattern;
        }
        return null;
    }

    public static SearchPattern createOrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return new OrPattern(leftPattern, rightPattern);
    }

    private static SearchPattern createScriptFolderPattern(String patternString, int limitTo, int matchRule) {
        return null;
    }

    public static SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, int matchRule, IDLTKLanguageToolkit toolkit) {
        if (stringPattern == null || stringPattern.length() == 0) {
            return null;
        }
        if ((matchRule = SearchPattern.validateMatchRule(stringPattern, matchRule)) == -1) {
            return null;
        }
        limitTo &= 0xFFFFFFCF;
        switch (searchFor) {
            case 8: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'A', toolkit);
            }
            case 0: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'C', toolkit);
            }
            case 1: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false, toolkit);
            }
            case 2: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule, toolkit);
            }
        }
        return null;
    }

    public static SearchPattern createPattern(IModelElement element, int limitTo) {
        return SearchPattern.createPattern(element, limitTo, 24, DLTKLanguageManager.getLanguageToolkit(element));
    }

    public static SearchPattern createPattern(IModelElement element, int limitTo, int matchRule, IDLTKLanguageToolkit toolkit) {
        SearchPattern searchPattern = null;
        boolean ignoreDeclaringType = false;
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        if (maskedLimitTo == 0 || maskedLimitTo == 2) {
            ignoreDeclaringType = (limitTo & 0x10) != 0;
        }
        char[] declaringSimpleName = null;
        char[] declaringQualification = null;
        Object enclosingNames = null;
        switch (element.getElementType()) {
            case 9: {
                char[] selector;
                boolean isConstructor;
                IMethod method = (IMethod)element;
                try {
                    isConstructor = method.isConstructor();
                }
                catch (ModelException e) {
                    return null;
                }
                IType declaringClass = method.getDeclaringType();
                if (ignoreDeclaringType) {
                    if (isConstructor) {
                        declaringSimpleName = declaringClass.getElementName().toCharArray();
                        enclosingNames = new char[][]{declaringSimpleName};
                    }
                } else if (declaringClass != null) {
                    declaringSimpleName = declaringClass.getElementName().toCharArray();
                    enclosingNames = SearchPattern.enclosingTypeNames(element);
                    if (((char[][])enclosingNames).length > 0) {
                        declaringSimpleName = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '$'), '$');
                    }
                }
                if ((selector = method.getElementName().toCharArray()).length == 0) {
                    return null;
                }
                boolean findMethodDeclarations = true;
                boolean findMethodReferences = true;
                switch (maskedLimitTo) {
                    case 0: {
                        findMethodReferences = false;
                        break;
                    }
                    case 1: {
                        findMethodDeclarations = false;
                        break;
                    }
                }
                MethodDeclarationPattern declarationPattern = null;
                MethodPattern referencesPattern = null;
                if (findMethodDeclarations) {
                    declarationPattern = new MethodDeclarationPattern((char[][])enclosingNames, selector, matchRule, toolkit);
                }
                if (findMethodReferences) {
                    referencesPattern = new MethodPattern(findMethodDeclarations, findMethodReferences, selector, declaringQualification, declaringSimpleName, method, matchRule, toolkit);
                }
                if (findMethodDeclarations) {
                    if (findMethodReferences) {
                        searchPattern = new OrPattern(declarationPattern, referencesPattern);
                        break;
                    }
                    searchPattern = declarationPattern;
                    break;
                }
                searchPattern = referencesPattern;
                break;
            }
            case 7: {
                IType type = (IType)element;
                char[] packageName = null;
                char[][] superTypes = null;
                try {
                    superTypes = CharOperation.stringArrayToCharCharArray(type.getSuperClasses());
                    packageName = SearchPattern.createPackagePattern(type.getNamespace());
                }
                catch (ModelException e) {
                    return null;
                }
                searchPattern = SearchPattern.createTypePattern(type.getElementName().toCharArray(), packageName, ignoreDeclaringType ? null : SearchPattern.enclosingTypeNames(type), superTypes, null, type, maskedLimitTo, matchRule);
                break;
            }
            case 4: {
                searchPattern = SearchPattern.createScriptFolderPattern(element.getElementName(), maskedLimitTo, matchRule);
                break;
            }
            case 8: {
                searchPattern = SearchPattern.createFieldPattern(element.getElementName(), maskedLimitTo, matchRule, toolkit);
                break;
            }
            case 13: {
                searchPattern = new LocalVariablePattern((ILocalVariable)element, maskedLimitTo, matchRule, toolkit);
            }
        }
        if (searchPattern != null) {
            MatchLocator.setFocus(searchPattern, element);
        }
        return searchPattern;
    }

    static char[] createPackagePattern(INamespace namespace) {
        if (namespace != null) {
            return CharOperation.concatWith(namespace.getStrings(), '$');
        }
        return null;
    }

    private static SearchPattern createTypePattern(char[] simpleName, char[] packageName, char[][] enclosingTypeNames, char[][] superTypes, String typeSignature, IType type, int limitTo, int matchRule) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        switch (limitTo) {
            case 0: {
                return new TypeDeclarationPattern(packageName, enclosingTypeNames, superTypes, simpleName, 'C', matchRule, toolkit);
            }
            case 1: {
                if (type != null) {
                    return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '$'), simpleName, type, matchRule, toolkit);
                }
                return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '$'), simpleName, matchRule, toolkit);
            }
            case 2: {
                return new OrPattern(new TypeDeclarationPattern(packageName, enclosingTypeNames, superTypes, simpleName, 'C', matchRule, toolkit), type != null ? new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '$'), simpleName, type, matchRule, toolkit) : new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '$'), simpleName, matchRule, toolkit));
            }
        }
        return null;
    }

    private static SearchPattern createTypePattern(String patternString, int limitTo, int matchRule, char indexSuffix, IDLTKLanguageToolkit toolkit) {
        String type = patternString;
        if (type == null) {
            return null;
        }
        ISearchPatternProcessor.ITypePattern typePattern = DLTKLanguageManager.getSearchPatternProcessor(toolkit, true).parseType(patternString);
        char[] qualificationChars = typePattern.qualification();
        char[] typeChars = typePattern.simpleName();
        if (typeChars.length == 1 && typeChars[0] == '*') {
            typeChars = null;
        }
        switch (limitTo) {
            case 0: {
                return new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule, toolkit);
            }
            case 1: {
                return new TypeReferencePattern(qualificationChars, typeChars, matchRule, toolkit);
            }
            case 2: {
                return new OrPattern(new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule, toolkit), new TypeReferencePattern(qualificationChars, typeChars, matchRule, toolkit));
            }
        }
        return null;
    }

    private static char[][] enclosingTypeNames(IModelElement element) {
        IModelElement parent = element.getParent();
        switch (parent.getElementType()) {
            case 5: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 8: 
            case 9: {
                IType declaringClass = ((IMember)parent).getDeclaringType();
                if (declaringClass == null) {
                    return null;
                }
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringClass), new char[][]{declaringClass.getElementName().toCharArray(), IIndexConstants.ONE_STAR});
            }
            case 7: {
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(parent), parent.getElementName().toCharArray());
            }
        }
        return null;
    }

    public void decodeIndexKey(char[] key) {
    }

    public abstract SearchPattern getBlankPattern();

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean emptyPattern;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            boolean isCamelCase = (this.matchRule & 0x80) != 0;
            int matchMode = this.matchRule & 7;
            boolean bl = emptyPattern = pattern.length == 0;
            if (matchMode == 1 && emptyPattern) {
                return true;
            }
            boolean sameLength = pattern.length == name.length;
            boolean canBePrefix = name.length >= pattern.length;
            boolean bl2 = matchFirstChar = !isCaseSensitive || emptyPattern || name.length > 0 && pattern[0] == name[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
                return true;
            }
            switch (matchMode) {
                case 0: 
                case 64: {
                    if (!isCamelCase) {
                        if (!sameLength || !matchFirstChar) break;
                        return CharOperation.equals(pattern, name, isCaseSensitive);
                    }
                }
                case 1: {
                    if (!canBePrefix || !matchFirstChar) break;
                    return CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 4: {
                    if (this.regexpCompiledPattern == null) {
                        this.regexpCompiledPattern = Pattern.compile(new String(pattern), isCaseSensitive ? 0 : 2);
                    }
                    return this.regexpCompiledPattern.matcher(new String(name)).matches();
                }
            }
        }
        return false;
    }

    public static int validateMatchRule(String stringPattern, int matchRule) {
        if ((matchRule & 4) != 0) {
            if ((matchRule & 2) != 0 || (matchRule & 1) != 0 || (matchRule & 0x80) != 0) {
                return -1;
            }
            try {
                Pattern.compile(stringPattern);
            }
            catch (PatternSyntaxException e) {
                return -1;
            }
        }
        int starIndex = stringPattern.indexOf(42);
        int questionIndex = stringPattern.indexOf(63);
        matchRule = starIndex < 0 && questionIndex < 0 ? (matchRule &= 0xFFFFFFFD) : (matchRule |= 2);
        if ((matchRule & 2) != 0) {
            matchRule &= 0xFFFFFF7F;
            matchRule &= 0xFFFFFFFE;
        }
        if ((matchRule & 0x80) != 0) {
            int length = stringPattern.length();
            boolean validCamelCase = true;
            boolean uppercase = false;
            int i = 0;
            while (i < length && validCamelCase) {
                char ch = stringPattern.charAt(i);
                validCamelCase = ScannerHelper.isScriptIdentifierStart(ch);
                if (!uppercase) {
                    uppercase = ScannerHelper.isUpperCase(ch);
                }
                ++i;
            }
            boolean bl = validCamelCase = validCamelCase && uppercase;
            if (validCamelCase) {
                if ((matchRule & 1) != 0 && (matchRule & 8) != 0) {
                    matchRule &= 0xFFFFFFFE;
                    matchRule &= 0xFFFFFFF7;
                }
            } else if (((matchRule &= 0xFFFFFF7F) & 1) == 0) {
                matchRule |= 1;
                matchRule |= 8;
            }
        }
        return matchRule;
    }

    public static final int[] getMatchingRegions(String pattern, String name, int matchRule) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length();
        if (pattern == null) {
            int[] nArray = new int[2];
            nArray[1] = nameLength;
            return nArray;
        }
        int patternLength = pattern.length();
        boolean countMatch = false;
        switch (matchRule) {
            case 0: {
                if (patternLength != nameLength || !pattern.equalsIgnoreCase(name)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 8: {
                if (patternLength != nameLength || !pattern.equals(name)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 1: {
                if (patternLength > nameLength || !name.substring(0, patternLength).equalsIgnoreCase(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 9: {
                if (!name.startsWith(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 256: {
                countMatch = true;
            }
            case 128: {
                if (patternLength > nameLength) break;
                int[] regions = StringOperation.getCamelCaseMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, countMatch);
                if (regions != null) {
                    return regions;
                }
                if (!name.substring(0, patternLength).equalsIgnoreCase(pattern)) break;
                int[] nArray = new int[2];
                nArray[1] = patternLength;
                return nArray;
            }
            case 264: {
                countMatch = true;
            }
            case 136: {
                if (patternLength > nameLength) break;
                return StringOperation.getCamelCaseMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, countMatch);
            }
            case 2: {
                return StringOperation.getPatternMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, false);
            }
            case 10: {
                return StringOperation.getPatternMatchingRegions(pattern, 0, patternLength, name, 0, nameLength, true);
            }
            case 512: {
                int[] nArray;
                if (patternLength > nameLength) break;
                int next = CharOperation.indexOf(pattern.toCharArray(), name.toCharArray(), false);
                if (next >= 0) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = next;
                    nArray = nArray2;
                    nArray2[1] = patternLength;
                } else {
                    nArray = null;
                }
                return nArray;
            }
        }
        return null;
    }

    public String toString() {
        return "SearchPattern";
    }
}

