/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class ColumnReorderEvent
extends ColumnStructuralChangeEvent {
    private Collection<Range> beforeFromColumnPositionRanges;
    private int beforeToColumnPosition;
    private boolean reorderToLeftEdge;

    public ColumnReorderEvent(ILayer layer, int beforeFromColumnPosition, int beforeToColumnPosition, boolean reorderToLeftEdge) {
        this(layer, Arrays.asList(beforeFromColumnPosition), beforeToColumnPosition, reorderToLeftEdge);
    }

    public ColumnReorderEvent(ILayer layer, List<Integer> beforeFromColumnPositions, int beforeToColumnPosition, boolean reorderToLeftEdge) {
        super(layer, new Range[0]);
        this.beforeFromColumnPositionRanges = PositionUtil.getRanges(beforeFromColumnPositions);
        this.reorderToLeftEdge = reorderToLeftEdge;
        this.beforeToColumnPosition = beforeToColumnPosition;
        ArrayList<Integer> allColumnPositions = new ArrayList<Integer>(beforeFromColumnPositions);
        allColumnPositions.add(beforeToColumnPosition);
        this.setColumnPositionRanges(PositionUtil.getRanges(allColumnPositions));
    }

    public ColumnReorderEvent(ColumnReorderEvent event) {
        super(event);
        this.beforeFromColumnPositionRanges = event.beforeFromColumnPositionRanges;
        this.beforeToColumnPosition = event.beforeToColumnPosition;
        this.reorderToLeftEdge = event.reorderToLeftEdge;
    }

    public Collection<Range> getBeforeFromColumnPositionRanges() {
        return this.beforeFromColumnPositionRanges;
    }

    public int getBeforeToColumnPosition() {
        return this.beforeToColumnPosition;
    }

    public boolean isReorderToLeftEdge() {
        return this.reorderToLeftEdge;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        int beforeToColumnPosition;
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        Collection<Range> beforeFromColumnPositionRanges = this.getBeforeFromColumnPositionRanges();
        int afterAddColumnPosition = beforeToColumnPosition = this.reorderToLeftEdge ? this.beforeToColumnPosition : this.beforeToColumnPosition + 1;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            if (beforeFromColumnPositionRange.start >= beforeToColumnPosition) break;
            afterAddColumnPosition -= Math.min(beforeFromColumnPositionRange.end, beforeToColumnPosition) - beforeFromColumnPositionRange.start;
        }
        int cumulativeAddSize = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            cumulativeAddSize += beforeFromColumnPositionRange.size();
        }
        int offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int afterDeleteColumnPosition = beforeFromColumnPositionRange.start - offset;
            if (afterAddColumnPosition < afterDeleteColumnPosition) {
                afterDeleteColumnPosition += cumulativeAddSize;
            }
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, beforeFromColumnPositionRange, new Range(afterDeleteColumnPosition, afterDeleteColumnPosition)));
            offset += beforeFromColumnPositionRange.size();
        }
        Range beforeAddRange = new Range(beforeToColumnPosition, beforeToColumnPosition);
        offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int size = beforeFromColumnPositionRange.size();
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, beforeAddRange, new Range(afterAddColumnPosition + offset, afterAddColumnPosition + offset + size)));
            offset += size;
        }
        return columnDiffs;
    }

    @Override
    public boolean convertToLocal(ILayer targetLayer) {
        this.beforeFromColumnPositionRanges = targetLayer.underlyingToLocalColumnPositions(this.getLayer(), this.beforeFromColumnPositionRanges);
        this.beforeToColumnPosition = targetLayer.underlyingToLocalColumnPosition(this.getLayer(), this.beforeToColumnPosition);
        if (this.beforeToColumnPosition >= 0) {
            return super.convertToLocal(targetLayer);
        }
        return false;
    }

    @Override
    public ColumnReorderEvent cloneEvent() {
        return new ColumnReorderEvent(this);
    }
}

