/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.executor.PivotReflectiveFragment;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.internal.library.executor.ReflectiveInheritance;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class CompleteInheritanceImpl
extends ReflectiveInheritance
implements CompleteInheritance {
    public static final @NonNull List<@NonNull CompleteInheritanceImpl> EMPTY_LIST = Collections.emptyList();
    public static final @NonNull BestOperation bestOperation = new BestOperation();
    protected final @NonNull CompleteClassInternal completeClass;

    public static @NonNull TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formalParameter, @NonNull Type type) {
        TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        templateParameterSubstitution.setFormal(formalParameter);
        templateParameterSubstitution.setActual(type);
        return templateParameterSubstitution;
    }

    public CompleteInheritanceImpl(@NonNull CompleteClassInternal completeClass) {
        super(ClassUtil.nonNullModel(completeClass.getName()), CompleteInheritanceImpl.computeFlags(completeClass.getPrimaryClass()), new ExecutorTypeParameter[0]);
        this.completeClass = completeClass;
    }

    @Override
    protected @NonNull AbstractFragment createFragment(@NonNull CompleteInheritance baseInheritance) {
        return new PivotReflectiveFragment(this, baseInheritance);
    }

    public @NonNull CompleteClassInternal getCompleteClass() {
        return this.completeClass;
    }

    @Override
    public @NonNull Iterable<@NonNull ? extends CompleteInheritance> getInitialSuperInheritances() {
        return this.isOclAny() ? EMPTY_LIST : this.completeClass.getPartialClasses().getInitialSuperInheritances();
    }

    public @NonNull List<? extends Operation> getLocalOperations() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedOperations());
    }

    public @NonNull List<? extends Property> getLocalProperties() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedProperties());
    }

    @Override
    public @Nullable Operation getMemberOperation(@NonNull OperationId operationId) {
        return this.completeClass.getOperation(operationId);
    }

    @Override
    public @Nullable Property getMemberProperty(@NonNull String propertyName) {
        return this.completeClass.getProperty(propertyName);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return this.completeClass.getPrimaryClass().getMetaTypeName();
    }

    @Override
    public @NonNull List<Property> getOwnedProperties() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedProperties());
    }

    @Override
    public @NonNull List<Operation> getOwnedOperations() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedOperations());
    }

    @Override
    public @NonNull Class getPivotClass() {
        return this.getCompleteClass().getPrimaryClass();
    }

    @Override
    public @NonNull List<Class> getSuperClasses() {
        ArrayList<Class> superClasses = new ArrayList<Class>();
        for (Class superClass : this.completeClass.getProperSuperClasses()) {
            superClasses.add(superClass);
        }
        return superClasses;
    }

    @Override
    public final @NonNull TypeId getTypeId() {
        return this.completeClass.getPrimaryClass().getTypeId();
    }

    @Override
    public @NonNull TemplateParameters getTypeParameters() {
        return TemplateParameters.EMPTY_LIST;
    }

    public String toString() {
        return this.completeClass.getPrimaryClass().toString();
    }

    @Override
    public void uninstall() {
        this.completeClass.uninstall();
        super.uninstall();
    }

    public static final class BestOperation
    implements Function<List<Operation>, Operation> {
        public Operation apply(List<Operation> operations) {
            return operations.get(0);
        }
    }
}

