/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.base.ui.outline.BaseOutlineNode;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.ITextRegion;

public class BaseOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    public static final @NonNull TracingOption CREATE = new TracingOption("org.eclipse.ocl.xtext.base.ui", "outline/create");

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf) {
        EObjectNode eObjectNode;
        Pivotable pivotable;
        Element pivot;
        EObject asElement = modelElement;
        if (modelElement instanceof Pivotable && (pivot = (pivotable = (Pivotable)modelElement).getPivot()) != null) {
            asElement = pivot;
        }
        if (asElement instanceof Element) {
            boolean isImplicit = false;
            ModelElementCS csElement = ElementUtil.getCsElement((Element)((Element)asElement));
            if (csElement == null) {
                csElement = this.getImplicitCsElement((Element)asElement);
                isImplicit = csElement != null;
            }
            eObjectNode = new BaseOutlineNode((Element)asElement, isImplicit, (ElementCS)csElement, parentNode, image, text, isLeaf);
        } else {
            eObjectNode = new EObjectNode(modelElement, parentNode, image, text, isLeaf);
        }
        if (asElement != null) {
            eObjectNode.setTextRegion(this.locationInFileProvider.getFullTextRegion(asElement));
            eObjectNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion(asElement));
        }
        if (CREATE.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append(modelElement.eClass().getName());
            s.append(" ");
            ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)eObjectNode.getFullTextRegion(), (boolean)false);
            s.append(" ");
            ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)eObjectNode.getSignificantTextRegion(), (boolean)true);
            s.append(" " + NameUtil.debugSimpleName((Object)eObjectNode) + " " + String.valueOf(eObjectNode.getText()).replace("\n", "\\n"));
            CREATE.println(s.toString());
        }
        return eObjectNode;
    }

    public void createChildren(IOutlineNode parent, EObject modelElement) {
        if (modelElement != null) {
            super.createChildren(parent, modelElement);
        }
    }

    protected void createNode(IOutlineNode parent, EObject modelElement) {
        if (modelElement != null) {
            super.createNode(parent, modelElement);
        }
    }

    protected @Nullable ElementCS getImplicitCsElement(@NonNull Element asElement) {
        return null;
    }

    protected void _createChildren(IOutlineNode parent, ModelElementCS csElement) {
        Element asElement = csElement.getPivot();
        if (parent instanceof BaseOutlineNode && ((BaseOutlineNode)parent).isImplicit() && asElement instanceof CallExp) {
            asElement = ((CallExp)asElement).getOwnedSource();
        }
        this.createChildren(parent, (EObject)asElement);
    }

    protected void _createNode(DocumentRootNode parentNode, ModelElementCS csElement) {
        this.createNode((IOutlineNode)parentNode, (EObject)csElement.getPivot());
    }

    protected void _createNode(IOutlineNode parent, ModelElementCS csElement) {
        this.createNode(parent, (EObject)csElement.getPivot());
    }

    protected void _createChildren(IOutlineNode parentNode, Constraint constraint) {
        this.createNode(parentNode, (EObject)constraint.getOwnedSpecification());
    }

    protected void _createChildren(IOutlineNode parentNode, Operation ele) {
        for (Parameter parameter : ele.getOwnedParameters()) {
            this.createNode(parentNode, (EObject)parameter);
        }
        this.createNode(parentNode, (EObject)ele.getBodyExpression());
    }
}

