/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.net.URL;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ProjectCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.WorkspaceCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationResource;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.ModelStyleSheets;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.w3c.dom.Element;

public class ModelCSSEngine
extends ExtendedCSSEngineImpl {
    private final Resource model;
    Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            ModelCSSEngine.this.reset();
            DiagramHelper.scheduleRefresh();
        }
    };

    public ModelCSSEngine(Resource model) {
        super(ModelCSSEngine.getParentCSSEngine(model));
        this.model = model;
        this.initAdapter();
    }

    public void initAdapter() {
        for (EObject eObject : this.model.getContents()) {
            if (!(eObject instanceof ModelStyleSheets)) continue;
            ModelStyleSheets styleSheets = (ModelStyleSheets)eObject;
            styleSheets.eAdapters().add((Object)this.adapter);
            for (StyleSheet styleSheet : styleSheets.getStylesheets()) {
                styleSheet.eAdapters().add((Object)this.adapter);
            }
        }
    }

    public void disposeAdapter() {
        for (EObject eObject : this.model.getContents()) {
            if (!(eObject instanceof ModelStyleSheets)) continue;
            ModelStyleSheets styleSheets = (ModelStyleSheets)eObject;
            styleSheets.eAdapters().remove((Object)this.adapter);
            for (StyleSheet styleSheet : styleSheets.getStylesheets()) {
                styleSheet.eAdapters().remove((Object)this.adapter);
            }
        }
    }

    private static ExtendedCSSEngine getParentCSSEngine(Resource resource) {
        ExtendedCSSEngine result = resource instanceof CSSNotationResource ? ((CSSNotationResource)resource).getProjectEngine() : ProjectCSSEngine.createEngine(resource);
        return result == null ? WorkspaceCSSEngine.instance : result;
    }

    @Override
    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        for (EObject eObject : this.model.getContents()) {
            if (!(eObject instanceof ModelStyleSheets)) continue;
            ModelStyleSheets styleSheets = (ModelStyleSheets)eObject;
            for (StyleSheet styleSheet : styleSheets.getStylesheets()) {
                this.styleSheets.add(styleSheet);
            }
        }
    }

    @Override
    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        URL url;
        Object path = styleSheet.getPath();
        if (((String)path).startsWith("/")) {
            path = "platform:/resource" + (String)path;
            url = new URL((String)path);
            try {
                url.openConnection();
            }
            catch (IOException ex) {
                path = "platform:/plugin" + styleSheet.getPath();
            }
        } else {
            URI uri = URI.createURI((String)styleSheet.getPath());
            uri = uri.resolve(this.model.getURI());
            path = uri.toString();
        }
        url = new URL((String)path);
        this.parseStyleSheet(url.openStream());
    }

    @Override
    public void dispose() {
        for (EObject eObject : this.model.getContents()) {
            if (!(eObject instanceof ModelStyleSheets)) continue;
            ModelStyleSheets styleSheets = (ModelStyleSheets)eObject;
            styleSheets.eAdapters().remove((Object)this.adapter);
            for (StyleSheet styleSheet : styleSheets.getStylesheets()) {
                styleSheet.eAdapters().remove((Object)this.adapter);
            }
        }
        super.dispose();
    }

    @Override
    public Element getElement(Object node) {
        throw new UnsupportedOperationException();
    }

    public IElementProvider getElementProvider() {
        throw new UnsupportedOperationException();
    }

    public void setElementProvider(IElementProvider elementProvider) {
        throw new UnsupportedOperationException();
    }

    public CSSElementContext getCSSElementContext(Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtendedCSSEngine.CascadeScope getCascadeScope() {
        return ExtendedCSSEngine.CascadeScope.AUTHOR;
    }
}

