/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.preferences;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.internal.ui.messages.Messages;
import org.eclipse.papyrus.infra.properties.internal.ui.runtime.ConfigurationConflict;
import org.eclipse.papyrus.infra.properties.internal.ui.runtime.IInternalConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.IConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    private String id;
    private final ContextState contextState = new ContextState();
    private Map<Context, Button> checkboxes = new HashMap<Context, Button>();

    public void init(IWorkbench workbench) {
    }

    public final String getID() {
        return this.id;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
    }

    protected Control createContents(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeaderContents(self);
        Label label = new Label(self, 0);
        label.setText(Messages.Preferences_Contexts);
        IConfigurationManager configurationManager = PropertiesRuntime.getConfigurationManager();
        List sortedContexts = configurationManager.getContextsForPreferencePage(this.getID()).stream().sorted(this.contextOrdering()).collect(Collectors.toList());
        for (Context context : sortedContexts) {
            boolean applied = configurationManager.isApplied(context);
            Button checkbox = new Button(self, 32);
            checkbox.setText(this.getLabel(context));
            checkbox.setSelection(applied);
            final Context theContext = context;
            this.contextState.setContextState(theContext, applied);
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Preferences.this.contextState.setContextState(theContext, ((Button)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.checkboxes.put(context, checkbox);
        }
        this.createFooterContents(self);
        this.contextState.snapshot();
        return null;
    }

    protected void createHeaderContents(Composite parent) {
    }

    protected void createFooterContents(Composite parent) {
    }

    protected Comparator<? super Context> contextOrdering() {
        return Comparator.comparingInt(this::getCategory).thenComparing(Comparator.comparing(Context::getUserLabel));
    }

    protected int getCategory(Context context) {
        IConfigurationManager mgr = PropertiesRuntime.getConfigurationManager();
        return mgr.isCustomizable(context) ? (mgr.isPlugin(context) ? 0 : 1) : 1000;
    }

    public boolean performOk() {
        return this.contextState.saveContext() && super.performOk();
    }

    public void performApply() {
        this.contextState.saveContext();
    }

    public void performDefaults() {
        IConfigurationManager mgr = PropertiesRuntime.getConfigurationManager();
        for (Context context : mgr.getContexts()) {
            boolean applied = mgr.isAppliedByDefault(context);
            Button checkbox = this.checkboxes.get(context);
            if (checkbox == null) continue;
            checkbox.setSelection(applied);
            this.contextState.setContextState(context, applied);
        }
    }

    private String getLabel(Context context) {
        String qualifier = PropertiesRuntime.getConfigurationManager().isPlugin(context) ? Messages.Preferences_Plugin : (PropertiesRuntime.getConfigurationManager().isMissing(context) ? "missing" : Messages.Preferences_Custom);
        return String.format("%s (%s)", context.getUserLabel(), qualifier);
    }

    private class ContextState {
        private Map<Context, Boolean> contexts = new HashMap<Context, Boolean>();
        private Map<Context, Boolean> snapshot;

        ContextState() {
        }

        void snapshot() {
            this.snapshot = new HashMap<Context, Boolean>(this.contexts);
        }

        public void setContextState(Context context, boolean applied) {
            this.contexts.put(context, applied);
        }

        public boolean saveContext() {
            IInternalConfigurationManager mgr = (IInternalConfigurationManager)PropertiesRuntime.getConfigurationManager();
            for (Map.Entry<Context, Boolean> entry : this.contexts.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    mgr.enableContext(entry.getKey(), false);
                    continue;
                }
                mgr.disableContext(entry.getKey(), false);
            }
            mgr.update();
            Set<Context> delta = this.getChangedContexts();
            if (!delta.isEmpty()) {
                Collection<ConfigurationConflict> conflicts = mgr.checkConflicts(delta);
                if (!conflicts.isEmpty()) {
                    Object errorMessage = Messages.Preferences_ConflictWarning1;
                    for (ConfigurationConflict conflict : conflicts) {
                        errorMessage = (String)errorMessage + conflict.toString() + "\n";
                    }
                    errorMessage = (String)errorMessage + Messages.Preferences_ConflictWarning2;
                    MessageDialog dialog = new MessageDialog(Preferences.this.getShell(), Messages.Preferences_ConflictWarningTitle, null, (String)errorMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                    int result = dialog.open();
                    if (result != 0) {
                        return false;
                    }
                }
                this.snapshot();
            }
            return true;
        }

        Set<Context> getChangedContexts() {
            return this.snapshot == null ? this.contexts.keySet() : this.snapshot.keySet().stream().filter(c -> !Objects.equals(this.snapshot.get(c), this.contexts.get(c))).collect(Collectors.toSet());
        }
    }
}

