/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.GmfEditorFactory;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.clazz.UmlClassDiagramForMultiEditor;

public class PackageDiagramEditorFactory
extends GmfEditorFactory {
    public PackageDiagramEditorFactory() {
        super(UmlClassDiagramForMultiEditor.class, "Package");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        this.migrate((Diagram)pageIdentifier);
        return super.createIPageModel(pageIdentifier);
    }

    private void migrate(final Diagram diagram) {
        TransactionalEditingDomain domain = null;
        try {
            domain = ServiceUtilsForResourceSet.getInstance().getTransactionalEditingDomain((Object)diagram.eResource().getResourceSet());
        }
        catch (ServiceException e) {
            return;
        }
        domain.getCommandStack().execute((Command)new AbstractCommand(){

            public void execute() {
                PolicyChecker checker = PolicyChecker.getFor((EObject)diagram);
                for (ViewPrototype prototype : checker.getAllPrototypes()) {
                    if (!"Package Diagram".equals(prototype.getLabel())) continue;
                    DiagramUtils.setPrototype((Diagram)diagram, (DiagramPrototype)((DiagramPrototype)prototype));
                    diagram.setType("PapyrusUMLClassDiagram");
                }
            }

            public void redo() {
                this.execute();
            }

            public boolean canExecute() {
                return true;
            }
        });
    }
}

