/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeOperationUtils {
    public static final String OPERATION_OF_STEREOTYPE_PREFIX = "operation_of_stereotype:/";

    public static Object getRealStereotypeOperation(EObject tableContext, String id) {
        Operation result = null;
        Assert.isTrue((boolean)id.startsWith(OPERATION_OF_STEREOTYPE_PREFIX));
        if (tableContext instanceof Element) {
            Element element = (Element)tableContext;
            String operationQN = id.replace(OPERATION_OF_STEREOTYPE_PREFIX, "");
            Package nearestPackage = element.getNearestPackage();
            if (nearestPackage != null && (result = (Operation)UMLUtil.findNamedElements((ResourceSet)nearestPackage.eResource().getResourceSet(), (String)operationQN, (boolean)false, (EClass)UMLPackage.eINSTANCE.getOperation()).stream().findFirst().orElse(null)) == null) {
                result = StereotypeOperationUtils.getOperation((Collection<Package>)element.getNearestPackage().getNestedPackages(), operationQN);
            }
        }
        return result;
    }

    public static Operation getOperation(Collection<Package> packages, String operationQN) {
        String operationName = NamedElementUtil.getNameFromQualifiedName((String)operationQN);
        String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)operationQN);
        String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
        String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
        for (Package package1 : packages) {
            for (Profile prof : package1.getAppliedProfiles()) {
                NamedElement prop;
                NamedElement ste;
                if (prof.getQualifiedName().equals(profileQN) && (ste = prof.getMember(stereotypeName)) instanceof Stereotype && (prop = ((Stereotype)ste).getMember(operationName)) instanceof Operation && prop.getQualifiedName().equals(operationQN)) {
                    return (Operation)prop;
                }
                Operation p = StereotypeOperationUtils.getOperation((Collection<Package>)package1.getNestedPackages(), operationQN);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    public static final List<Stereotype> getAppliedStereotypesWithThisOperation(Element element, String id) {
        Object operation;
        Assert.isTrue((boolean)id.startsWith(OPERATION_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (element.eResource() != null && (operation = StereotypeOperationUtils.getRealStereotypeOperation((EObject)element, id)) instanceof Operation) {
            for (Stereotype current : element.getAppliedStereotypes()) {
                if (!current.getAllOperations().contains(operation)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }
}

