/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.IRSEInteractionProvider;
import org.eclipse.rse.core.IRSERunnableWithProgress;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DefaultUIInteractionProvider
implements IRSEInteractionProvider {
    private Shell shell = null;

    protected IRunnableContext getRunnableContext() {
        Shell winShell;
        if (Display.getCurrent() == null) {
            return new NullRunnableContext();
        }
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc != null) {
            SystemBasePlugin.logInfo("Got runnable context from system registry");
            return irc;
        }
        IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
        if (win != null && (winShell = DefaultUIInteractionProvider.getActiveWorkbenchShell()) != null && !winShell.isDisposed() && winShell.isVisible()) {
            SystemBasePlugin.logInfo("Using active workbench window as runnable context");
            this.shell = winShell;
            return win;
        }
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.shell);
        return dlg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Shell getActiveWorkbenchShell() {
        Shell result = null;
        if (!PlatformUI.isWorkbenchRunning()) return null;
        try {
            IWorkbenchWindow window = DefaultUIInteractionProvider.getActiveWorkbenchWindow();
            if (window == null) return result;
            return window.getShell();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public void runInDefaultContext(boolean fork, boolean cancellable, IRSERunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
    }

    private Display getDefaultDisplay() {
        Display d = Display.getCurrent();
        if (d == null && (d = SystemBasePlugin.getActiveWorkbenchShell().getDisplay()) == null) {
            d = Display.getDefault();
        }
        return d;
    }

    public void asyncExec(Runnable runnable) {
        this.getDefaultDisplay().asyncExec(runnable);
    }

    public void eventExec(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            this.asyncExec(runnable);
        }
    }

    public void flushRunnableQueue() {
        Display d = Display.getCurrent();
        if (d == null) {
            this.getDefaultDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultUIInteractionProvider.this.flushRunnableQueue();
                }
            });
        } else {
            while (d.readAndDispatch()) {
            }
        }
    }

    public IProgressMonitor getDefaultProgressMonitor() {
        return null;
    }

    public void showMessage(SystemMessage msg) {
    }

    private class NullRunnableContext
    implements IRunnableContext {
        private NullRunnableContext() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            NullProgressMonitor monitor = new NullProgressMonitor();
            runnable.run((IProgressMonitor)monitor);
        }
    }
}

