/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.navigator;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.runtime.services.interfaces.delegates.ILabelProviderDelegate;
import org.eclipse.tcf.te.ui.views.extensions.LabelProviderDelegateExtensionPointManager;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class DelegatingLabelProvider
extends LabelProvider
implements ILabelDecorator,
ILabelProviderDelegate,
IDescriptionProvider,
IColorProvider,
IFontProvider {
    public String getText(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                ILabelProvider delegate = iLabelProviderArray[n2];
                String text = delegate.getText(element);
                if (text != null) {
                    return text;
                }
                ++n2;
            }
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                ILabelProvider delegate = iLabelProviderArray[n2];
                Image image = delegate.getImage(element);
                if (image != null) {
                    return image;
                }
                ++n2;
            }
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                Image candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof ILabelDecorator && (candidate = ((ILabelDecorator)delegate).decorateImage(image, element)) != null && candidate != image) {
                    return candidate;
                }
                ++n2;
            }
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof ILabelDecorator && (candidate = ((ILabelDecorator)delegate).decorateText(text, element)) != null) {
                    return candidate;
                }
                ++n2;
            }
        }
        return text;
    }

    public String getDescription(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        String description = null;
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof IDescriptionProvider && (candidate = ((IDescriptionProvider)delegate).getDescription(element)) != null) {
                    description = candidate;
                    break;
                }
                ++n2;
            }
        }
        return String.valueOf(this.decorateText(this.getText(element), element)) + (description != null ? " - " + description : "");
    }

    public Font getFont(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                Font candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof IFontProvider && (candidate = ((IFontProvider)delegate).getFont(element)) != null) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                Color candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof IColorProvider && (candidate = ((IColorProvider)delegate).getForeground(element)) != null) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0) {
            ILabelProvider[] iLabelProviderArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                Color candidate;
                ILabelProvider delegate = iLabelProviderArray[n2];
                if (delegate instanceof IColorProvider && (candidate = ((IColorProvider)delegate).getBackground(element)) != null) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }
}

