/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs.factory;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.AbstractPaletteDialog;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.CheckedListDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IListAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.ListDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class FactoriesAddDialog
extends AbstractPaletteDialog {
    private final AstEditor m_editor;
    private final PaletteInfo m_palette;
    private final CategoryInfo m_initialCategory;
    private final boolean m_forStatic;
    private StringButtonDialogField m_factoryClassField;
    private CheckedListDialogField<String> m_signaturesField;
    private ComboDialogField m_categoryField;
    private String m_factoryClassName;
    private Composite m_fieldsContainer;

    public FactoriesAddDialog(Shell parentShell, AstEditor editor, PaletteInfo palette, CategoryInfo initialCategory, boolean forStatic) {
        super(parentShell, forStatic ? Messages.FactoriesAddDialog_shellTitleStatic : Messages.FactoriesAddDialog_shellTitleInstance, forStatic ? Messages.FactoriesAddDialog_titleStatic : Messages.FactoriesAddDialog_titleInstance, null, Messages.FactoriesAddDialog_message);
        this.m_editor = editor;
        this.m_palette = palette;
        this.m_initialCategory = initialCategory;
        this.m_forStatic = forStatic;
        this.setShellStyle(2160);
    }

    protected void createControls(Composite container) {
        this.m_fieldsContainer = container;
        GridLayoutFactory.create((Composite)container).columns(3);
        this.m_factoryClassField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                try {
                    String factoryClassName = JdtUiUtils.selectTypeName(FactoriesAddDialog.this.getShell(), FactoriesAddDialog.this.m_editor.getJavaProject());
                    if (factoryClassName != null) {
                        FactoriesAddDialog.this.m_factoryClassField.setText(factoryClassName);
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        });
        this.m_factoryClassField.setButtonLabel(Messages.FactoriesAddDialog_classChoose);
        this.doCreateField((DialogField)this.m_factoryClassField, Messages.FactoriesAddDialog_classLabel);
        this.m_factoryClassField.getTextControl(null).setEditable(false);
        this.m_signaturesField = new CheckedListDialogField((IListAdapter)new IListAdapter<String>(){

            public void selectionChanged(ListDialogField<String> field) {
            }

            public void doubleClicked(ListDialogField<String> field) {
            }

            public void customButtonPressed(ListDialogField<String> field, int index) {
            }
        }, new String[]{Messages.FactoriesAddDialog_selectAllButton, Messages.FactoriesAddDialog_deselectAllButton}, (ILabelProvider)new LabelProvider());
        this.m_signaturesField.setCheckAllButtonIndex(0);
        this.m_signaturesField.setUncheckAllButtonIndex(1);
        this.doCreateField((DialogField)this.m_signaturesField, Messages.FactoriesAddDialog_methodsLabel);
        this.m_categoryField = FactoriesAddDialog.createCategoryField(this.m_palette, this.m_initialCategory);
        this.doCreateField((DialogField)this.m_categoryField, Messages.FactoriesAddDialog_categoryLabel);
    }

    protected String validate() {
        String factoryClassName = this.m_factoryClassField.getText().trim();
        if (factoryClassName.length() == 0) {
            return Messages.FactoriesAddDialog_validateEmptyClass;
        }
        if (!factoryClassName.equals(this.m_factoryClassName)) {
            this.m_factoryClassName = factoryClassName;
            try {
                EditorState state = EditorState.get(this.m_editor);
                Class<?> factoryClass = state.getEditorLoader().loadClass(factoryClassName);
                Map<String, FactoryMethodDescription> signaturesMap = FactoryDescriptionHelper.getDescriptionsMap(this.m_editor, factoryClass, this.m_forStatic);
                this.m_signaturesField.setElements(signaturesMap.keySet());
                if (signaturesMap.isEmpty()) {
                    return MessageFormat.format(Messages.FactoriesAddDialog_validateNoMethods, factoryClassName);
                }
            }
            catch (Throwable e) {
                return e.getClass().getName() + ": " + e.getMessage();
            }
        }
        if (this.m_signaturesField.getCheckedElements().isEmpty()) {
            return Messages.FactoriesAddDialog_validateNoMethodSelection;
        }
        return null;
    }

    public List<Command> getCommands() {
        CategoryInfo category = this.m_palette.getCategories().get(this.m_categoryField.getSelectionIndex());
        List signatures = this.m_signaturesField.getCheckedElements();
        ArrayList<Command> commands = new ArrayList<Command>();
        int i = 0;
        while (i < signatures.size()) {
            String signature = (String)signatures.get(i);
            String id = "custom_" + System.currentTimeMillis() + "_" + i;
            String name = signature;
            String description = null;
            commands.add(new FactoryAddCommand(id, name, description, true, this.m_factoryClassName, signature, this.m_forStatic, category));
            ++i;
        }
        return commands;
    }

    protected void doCreateField(DialogField dialogField, String labelText) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)3, (int)60);
    }
}

