/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.databinding.xsd.component.Component;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.accessor.MethodInvocationAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.MethodInvocationArgumentAccessor;
import org.eclipse.wb.internal.core.model.property.editor.MethodPropertyPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class MethodPropertyRule
implements FailableBiConsumer<ComponentDescription, Component.MethodProperty, Exception> {
    private final IJavaProject m_javaProject;

    public MethodPropertyRule(IJavaProject javaProject) {
        this.m_javaProject = javaProject;
    }

    public void accept(ComponentDescription componentDescription, Component.MethodProperty methodProperty) throws Exception {
        String methodSignature;
        Class<?> componentClass = componentDescription.getComponentClass();
        String propertyTitle = methodProperty.getTitle();
        String propertyId = methodSignature = methodProperty.getMethod();
        Method method = ReflectionUtils.getMethodBySignature(componentClass, (String)methodSignature);
        Assert.isNotNull((Object)method, (String)"Method %s in %s.", (Object[])new Object[]{methodSignature, componentClass});
        MethodDescription methodDescription = componentDescription.addMethod(method);
        ComponentDescriptionHelper.ensureInitialized(this.m_javaProject, methodDescription);
        MethodInvocationAccessor accessor = new MethodInvocationAccessor(method);
        ArrayList<GenericPropertyDescription> descriptions = new ArrayList<GenericPropertyDescription>();
        for (ParameterDescription parameter : methodDescription.getParameters()) {
            GenericPropertyDescription description = MethodPropertyRule.createPropertyDescription(method, propertyId, parameter);
            if (description == null) continue;
            descriptions.add(description);
            componentDescription.registerProperty(description);
        }
        MethodPropertyPropertyEditor editor = new MethodPropertyPropertyEditor("(properties)", descriptions);
        GenericPropertyDescription propertyDescription = new GenericPropertyDescription(propertyId, propertyTitle);
        propertyDescription.addAccessor(accessor);
        propertyDescription.setEditor((PropertyEditor)editor);
        componentDescription.addProperty(propertyDescription);
    }

    private static GenericPropertyDescription createPropertyDescription(Method method, String methodPropertyId, ParameterDescription parameter) {
        if (parameter.getEditor() != null) {
            String propertyId = methodPropertyId + " " + parameter.getIndex();
            String propertyTitle = parameter.getName();
            GenericPropertyDescription propertyDescription = new GenericPropertyDescription(propertyId, propertyTitle);
            MethodInvocationArgumentAccessor accessor = new MethodInvocationArgumentAccessor(method, parameter.getIndex());
            propertyDescription.addAccessor(accessor);
            propertyDescription.setConverter(parameter.getConverter());
            propertyDescription.setEditor(parameter.getEditor());
            return propertyDescription;
        }
        return null;
    }
}

