/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerMount;
import org.mandas.docker.client.messages.NetworkSettings;

final class ImmutableContainer
implements Container {
    private final String id;
    @Nullable
    private final List<String> names;
    private final String image;
    @Nullable
    private final String imageId;
    private final String command;
    private final Long created;
    @Nullable
    private final String state;
    private final String status;
    @Nullable
    private final List<Container.PortMapping> ports;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final Long sizeRw;
    @Nullable
    private final Long sizeRootFs;
    @Nullable
    private final NetworkSettings networkSettings;
    @Nullable
    private final List<ContainerMount> mounts;
    private final transient String portsAsString;

    private ImmutableContainer(String id, @Nullable List<String> names, String image, @Nullable String imageId, String command, Long created, @Nullable String state, String status, @Nullable List<Container.PortMapping> ports, @Nullable Map<String, String> labels, @Nullable Long sizeRw, @Nullable Long sizeRootFs, @Nullable NetworkSettings networkSettings, @Nullable List<ContainerMount> mounts) {
        this.id = id;
        this.names = names;
        this.image = image;
        this.imageId = imageId;
        this.command = command;
        this.created = created;
        this.state = state;
        this.status = status;
        this.ports = ports;
        this.labels = labels;
        this.sizeRw = sizeRw;
        this.sizeRootFs = sizeRootFs;
        this.networkSettings = networkSettings;
        this.mounts = mounts;
        this.portsAsString = Objects.requireNonNull(Container.super.portsAsString(), "portsAsString");
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Names")
    @Nullable
    public List<String> names() {
        return this.names;
    }

    @Override
    @JsonProperty(value="Image")
    public String image() {
        return this.image;
    }

    @Override
    @JsonProperty(value="ImageID")
    @Nullable
    public String imageId() {
        return this.imageId;
    }

    @Override
    @JsonProperty(value="Command")
    public String command() {
        return this.command;
    }

    @Override
    @JsonProperty(value="Created")
    public Long created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="State")
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="Status")
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="Ports")
    @Nullable
    public List<Container.PortMapping> ports() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="SizeRw")
    @Nullable
    public Long sizeRw() {
        return this.sizeRw;
    }

    @Override
    @JsonProperty(value="SizeRootFs")
    @Nullable
    public Long sizeRootFs() {
        return this.sizeRootFs;
    }

    @Override
    @JsonProperty(value="NetworkSettings")
    @Nullable
    public NetworkSettings networkSettings() {
        return this.networkSettings;
    }

    @Override
    @JsonProperty(value="Mounts")
    @Nullable
    public List<ContainerMount> mounts() {
        return this.mounts;
    }

    @Override
    @JsonProperty(value="portsAsString")
    @JsonIgnore
    public String portsAsString() {
        return this.portsAsString;
    }

    public final ImmutableContainer withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableContainer(newValue, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withNames(String ... elements) {
        if (elements == null) {
            return new ImmutableContainer(this.id, null, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainer(this.id, newValue, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withNames(@Nullable Iterable<String> elements) {
        if (this.names == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(elements, true, false));
        return new ImmutableContainer(this.id, newValue, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withImage(String value) {
        String newValue = Objects.requireNonNull(value, "image");
        if (this.image.equals(newValue)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, newValue, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withImageId(@Nullable String value) {
        if (Objects.equals(this.imageId, value)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, value, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withCommand(String value) {
        String newValue = Objects.requireNonNull(value, "command");
        if (this.command.equals(newValue)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, newValue, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withCreated(Long value) {
        Long newValue = Objects.requireNonNull(value, "created");
        if (this.created.equals(newValue)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, newValue, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, value, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, newValue, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withPorts(Container.PortMapping ... elements) {
        if (elements == null) {
            return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, null, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
        }
        List<Container.PortMapping> newValue = Arrays.asList(elements) == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, newValue, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withPorts(@Nullable Iterable<? extends Container.PortMapping> elements) {
        if (this.ports == elements) {
            return this;
        }
        List<Container.PortMapping> newValue = elements == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(elements, true, false));
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, newValue, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableContainer.createUnmodifiableMap(true, false, entries);
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, newValue, this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withSizeRw(@Nullable Long value) {
        if (Objects.equals(this.sizeRw, value)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, value, this.sizeRootFs, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withSizeRootFs(@Nullable Long value) {
        if (Objects.equals(this.sizeRootFs, value)) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, value, this.networkSettings, this.mounts);
    }

    public final ImmutableContainer withNetworkSettings(@Nullable NetworkSettings value) {
        if (this.networkSettings == value) {
            return this;
        }
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, value, this.mounts);
    }

    public final ImmutableContainer withMounts(ContainerMount ... elements) {
        if (elements == null) {
            return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, null);
        }
        List<ContainerMount> newValue = Arrays.asList(elements) == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, newValue);
    }

    public final ImmutableContainer withMounts(@Nullable Iterable<? extends ContainerMount> elements) {
        if (this.mounts == elements) {
            return this;
        }
        List<ContainerMount> newValue = elements == null ? null : ImmutableContainer.createUnmodifiableList(false, ImmutableContainer.createSafeList(elements, true, false));
        return new ImmutableContainer(this.id, this.names, this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.networkSettings, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainer && this.equalTo(0, (ImmutableContainer)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainer another) {
        return this.id.equals(another.id) && Objects.equals(this.names, another.names) && this.image.equals(another.image) && Objects.equals(this.imageId, another.imageId) && this.command.equals(another.command) && this.created.equals(another.created) && Objects.equals(this.state, another.state) && this.status.equals(another.status) && Objects.equals(this.ports, another.ports) && Objects.equals(this.labels, another.labels) && Objects.equals(this.sizeRw, another.sizeRw) && Objects.equals(this.sizeRootFs, another.sizeRootFs) && Objects.equals(this.networkSettings, another.networkSettings) && Objects.equals(this.mounts, another.mounts) && this.portsAsString.equals(another.portsAsString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + Objects.hashCode(this.imageId);
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.ports);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.sizeRw);
        h += (h << 5) + Objects.hashCode(this.sizeRootFs);
        h += (h << 5) + Objects.hashCode(this.networkSettings);
        h += (h << 5) + Objects.hashCode(this.mounts);
        h += (h << 5) + this.portsAsString.hashCode();
        return h;
    }

    public String toString() {
        return "Container{id=" + this.id + ", names=" + this.names + ", image=" + this.image + ", imageId=" + this.imageId + ", command=" + this.command + ", created=" + this.created + ", state=" + this.state + ", status=" + this.status + ", ports=" + this.ports + ", labels=" + this.labels + ", sizeRw=" + this.sizeRw + ", sizeRootFs=" + this.sizeRootFs + ", networkSettings=" + this.networkSettings + ", mounts=" + this.mounts + ", portsAsString=" + this.portsAsString + "}";
    }

    public static ImmutableContainer copyOf(Container instance) {
        if (instance instanceof ImmutableContainer) {
            return (ImmutableContainer)instance;
        }
        return ImmutableContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IMAGE = 2L;
        private static final long INIT_BIT_COMMAND = 4L;
        private static final long INIT_BIT_CREATED = 8L;
        private static final long INIT_BIT_STATUS = 16L;
        private long initBits = 31L;
        private String id;
        private List<String> names = null;
        private String image;
        private String imageId;
        private String command;
        private Long created;
        private String state;
        private String status;
        private List<Container.PortMapping> ports = null;
        private Map<String, String> labels = null;
        private Long sizeRw;
        private Long sizeRootFs;
        private NetworkSettings networkSettings;
        private List<ContainerMount> mounts = null;

        private Builder() {
        }

        public final Builder from(Container instance) {
            List<ContainerMount> mountsValue;
            NetworkSettings networkSettingsValue;
            Long sizeRootFsValue;
            Long sizeRwValue;
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            List<String> namesValue = instance.names();
            if (namesValue != null) {
                this.addAllNames(namesValue);
            }
            this.image(instance.image());
            String imageIdValue = instance.imageId();
            if (imageIdValue != null) {
                this.imageId(imageIdValue);
            }
            this.command(instance.command());
            this.created(instance.created());
            String stateValue = instance.state();
            if (stateValue != null) {
                this.state(stateValue);
            }
            this.status(instance.status());
            List<Container.PortMapping> portsValue = instance.ports();
            if (portsValue != null) {
                this.addAllPorts(portsValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((sizeRwValue = instance.sizeRw()) != null) {
                this.sizeRw(sizeRwValue);
            }
            if ((sizeRootFsValue = instance.sizeRootFs()) != null) {
                this.sizeRootFs(sizeRootFsValue);
            }
            if ((networkSettingsValue = instance.networkSettings()) != null) {
                this.networkSettings(networkSettingsValue);
            }
            if ((mountsValue = instance.mounts()) != null) {
                this.addAllMounts(mountsValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        @JsonProperty(value="Names")
        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        @JsonProperty(value="Image")
        public final Builder image(String image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ImageID")
        public final Builder imageId(@Nullable String imageId) {
            this.imageId = imageId;
            return this;
        }

        @JsonProperty(value="Command")
        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(Long created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="State")
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="Status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder port(Container.PortMapping element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Container.PortMapping>();
            }
            this.ports.add(Objects.requireNonNull(element, "ports element"));
            return this;
        }

        public final Builder ports(Container.PortMapping ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Container.PortMapping>();
            }
            for (Container.PortMapping element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        @JsonProperty(value="Ports")
        public final Builder ports(@Nullable Iterable<? extends Container.PortMapping> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Container.PortMapping>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<? extends Container.PortMapping> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Container.PortMapping>();
            }
            for (Container.PortMapping portMapping : elements) {
                this.ports.add(Objects.requireNonNull(portMapping, "ports element"));
            }
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="SizeRw")
        public final Builder sizeRw(@Nullable Long sizeRw) {
            this.sizeRw = sizeRw;
            return this;
        }

        @JsonProperty(value="SizeRootFs")
        public final Builder sizeRootFs(@Nullable Long sizeRootFs) {
            this.sizeRootFs = sizeRootFs;
            return this;
        }

        @JsonProperty(value="NetworkSettings")
        public final Builder networkSettings(@Nullable NetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final Builder mount(ContainerMount element) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            return this;
        }

        public final Builder mounts(ContainerMount ... elements) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            for (ContainerMount element : elements) {
                this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            }
            return this;
        }

        @JsonProperty(value="Mounts")
        public final Builder mounts(@Nullable Iterable<? extends ContainerMount> elements) {
            if (elements == null) {
                this.mounts = null;
                return this;
            }
            this.mounts = new ArrayList<ContainerMount>();
            return this.addAllMounts(elements);
        }

        public final Builder addAllMounts(Iterable<? extends ContainerMount> elements) {
            Objects.requireNonNull(elements, "mounts element");
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            for (ContainerMount containerMount : elements) {
                this.mounts.add(Objects.requireNonNull(containerMount, "mounts element"));
            }
            return this;
        }

        public ImmutableContainer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainer(this.id, this.names == null ? null : ImmutableContainer.createUnmodifiableList(true, this.names), this.image, this.imageId, this.command, this.created, this.state, this.status, this.ports == null ? null : ImmutableContainer.createUnmodifiableList(true, this.ports), this.labels == null ? null : ImmutableContainer.createUnmodifiableMap(false, false, this.labels), this.sizeRw, this.sizeRootFs, this.networkSettings, this.mounts == null ? null : ImmutableContainer.createUnmodifiableList(true, this.mounts));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("image");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build Container, some of required attributes are not set " + attributes;
        }
    }

    static final class PortMapping
    implements Container.PortMapping {
        private final int privatePort;
        private final int publicPort;
        private final String type;
        @Nullable
        private final String ip;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private PortMapping(Builder builder) {
            this.type = builder.type;
            this.ip = builder.ip;
            if (builder.privatePortIsSet()) {
                this.initShim.privatePort(builder.privatePort);
            }
            if (builder.publicPortIsSet()) {
                this.initShim.publicPort(builder.publicPort);
            }
            this.privatePort = this.initShim.privatePort();
            this.publicPort = this.initShim.publicPort();
            this.initShim = null;
        }

        private PortMapping(int privatePort, int publicPort, String type, @Nullable String ip) {
            this.privatePort = privatePort;
            this.publicPort = publicPort;
            this.type = type;
            this.ip = ip;
            this.initShim = null;
        }

        private int privatePortInitialize() {
            return Container.PortMapping.super.privatePort();
        }

        private int publicPortInitialize() {
            return Container.PortMapping.super.publicPort();
        }

        @Override
        @JsonProperty(value="PrivatePort")
        public int privatePort() {
            InitShim shim = this.initShim;
            return shim != null ? shim.privatePort() : this.privatePort;
        }

        @Override
        @JsonProperty(value="PublicPort")
        public int publicPort() {
            InitShim shim = this.initShim;
            return shim != null ? shim.publicPort() : this.publicPort;
        }

        @Override
        @JsonProperty(value="Type")
        public String type() {
            return this.type;
        }

        @Override
        @JsonProperty(value="IP")
        @Nullable
        public String ip() {
            return this.ip;
        }

        public final PortMapping withPrivatePort(int value) {
            if (this.privatePort == value) {
                return this;
            }
            return new PortMapping(value, this.publicPort, this.type, this.ip);
        }

        public final PortMapping withPublicPort(int value) {
            if (this.publicPort == value) {
                return this;
            }
            return new PortMapping(this.privatePort, value, this.type, this.ip);
        }

        public final PortMapping withType(String value) {
            String newValue = Objects.requireNonNull(value, "type");
            if (this.type.equals(newValue)) {
                return this;
            }
            return new PortMapping(this.privatePort, this.publicPort, newValue, this.ip);
        }

        public final PortMapping withIp(@Nullable String value) {
            if (Objects.equals(this.ip, value)) {
                return this;
            }
            return new PortMapping(this.privatePort, this.publicPort, this.type, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PortMapping && this.equalTo(0, (PortMapping)another);
        }

        private boolean equalTo(int synthetic, PortMapping another) {
            return this.privatePort == another.privatePort && this.publicPort == another.publicPort && this.type.equals(another.type) && Objects.equals(this.ip, another.ip);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.privatePort;
            h += (h << 5) + this.publicPort;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + Objects.hashCode(this.ip);
            return h;
        }

        public String toString() {
            return "PortMapping{privatePort=" + this.privatePort + ", publicPort=" + this.publicPort + ", type=" + this.type + ", ip=" + this.ip + "}";
        }

        public static PortMapping copyOf(Container.PortMapping instance) {
            if (instance instanceof PortMapping) {
                return (PortMapping)instance;
            }
            return PortMapping.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        private final class InitShim {
            private byte privatePortBuildStage = 0;
            private int privatePort;
            private byte publicPortBuildStage = 0;
            private int publicPort;

            private InitShim() {
            }

            int privatePort() {
                if (this.privatePortBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.privatePortBuildStage == 0) {
                    this.privatePortBuildStage = (byte)-1;
                    this.privatePort = PortMapping.this.privatePortInitialize();
                    this.privatePortBuildStage = 1;
                }
                return this.privatePort;
            }

            void privatePort(int privatePort) {
                this.privatePort = privatePort;
                this.privatePortBuildStage = 1;
            }

            int publicPort() {
                if (this.publicPortBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.publicPortBuildStage == 0) {
                    this.publicPortBuildStage = (byte)-1;
                    this.publicPort = PortMapping.this.publicPortInitialize();
                    this.publicPortBuildStage = 1;
                }
                return this.publicPort;
            }

            void publicPort(int publicPort) {
                this.publicPort = publicPort;
                this.publicPortBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.privatePortBuildStage == -1) {
                    attributes.add("privatePort");
                }
                if (this.publicPortBuildStage == -1) {
                    attributes.add("publicPort");
                }
                return "Cannot build PortMapping, attribute initializers form cycle " + attributes;
            }
        }

        static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private static final long OPT_BIT_PRIVATE_PORT = 1L;
            private static final long OPT_BIT_PUBLIC_PORT = 2L;
            private long initBits = 1L;
            private long optBits;
            private int privatePort;
            private int publicPort;
            private String type;
            private String ip;

            private Builder() {
            }

            public final Builder from(Container.PortMapping instance) {
                Objects.requireNonNull(instance, "instance");
                this.privatePort(instance.privatePort());
                this.publicPort(instance.publicPort());
                this.type(instance.type());
                String ipValue = instance.ip();
                if (ipValue != null) {
                    this.ip(ipValue);
                }
                return this;
            }

            @JsonProperty(value="PrivatePort")
            public final Builder privatePort(int privatePort) {
                this.privatePort = privatePort;
                this.optBits |= 1L;
                return this;
            }

            @JsonProperty(value="PublicPort")
            public final Builder publicPort(int publicPort) {
                this.publicPort = publicPort;
                this.optBits |= 2L;
                return this;
            }

            @JsonProperty(value="Type")
            public final Builder type(String type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="IP")
            public final Builder ip(@Nullable String ip) {
                this.ip = ip;
                return this;
            }

            public PortMapping build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PortMapping(this);
            }

            private boolean privatePortIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean publicPortIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build PortMapping, some of required attributes are not set " + attributes;
            }
        }
    }
}

