/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;

public class VisualizerModel {
    protected ArrayList<VisualizerCPU> m_cpus;
    protected Hashtable<Integer, VisualizerCPU> m_cpuMap;
    protected ArrayList<VisualizerThread> m_threads;
    private boolean m_keepExitedThreads = false;
    protected boolean m_loadMetersEnabled = false;
    protected String m_sessionId = null;

    public VisualizerModel(String sessionId) {
        this.m_sessionId = sessionId;
        this.m_cpus = new ArrayList();
        this.m_cpuMap = new Hashtable();
        this.m_threads = new ArrayList();
    }

    public void dispose() {
        if (this.m_cpus != null) {
            for (VisualizerCPU cpu : this.m_cpus) {
                cpu.dispose();
            }
            this.m_cpuMap.clear();
            this.m_cpuMap = null;
            this.m_cpus.clear();
            this.m_cpus = null;
        }
        if (this.m_threads != null) {
            for (VisualizerThread thread : this.m_threads) {
                thread.dispose();
            }
            this.m_threads.clear();
            this.m_threads = null;
        }
        this.m_sessionId = null;
    }

    public void setLoadMetersEnabled(boolean enable) {
        this.m_loadMetersEnabled = enable;
    }

    public boolean getLoadMetersEnabled() {
        return this.m_loadMetersEnabled;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void sort() {
        Collections.sort(this.m_cpus);
        for (VisualizerCPU cpu : this.m_cpus) {
            cpu.sort();
        }
        Collections.sort(this.m_threads);
    }

    public int getCPUCount() {
        return this.m_cpus.size();
    }

    public int getCoreCount() {
        int count = 0;
        for (VisualizerCPU cpu : this.m_cpus) {
            count += cpu.getCoreCount();
        }
        return count;
    }

    public int getThreadCount() {
        return this.m_threads.size();
    }

    public VisualizerCPU getCPU(int id) {
        return this.m_cpuMap.get(id);
    }

    public VisualizerCore getCore(int id) {
        VisualizerCore result = null;
        for (VisualizerCPU cpu : this.m_cpus) {
            result = cpu.getCore(id);
            if (result != null) break;
        }
        return result;
    }

    public List<VisualizerCPU> getCPUs() {
        return this.m_cpus;
    }

    public VisualizerCPU addCPU(VisualizerCPU cpu) {
        this.m_cpus.add(cpu);
        this.m_cpuMap.put(cpu.getID(), cpu);
        return cpu;
    }

    public void removeCPU(VisualizerCPU cpu) {
        this.m_cpus.remove(cpu);
        this.m_cpuMap.remove(cpu.getID());
    }

    public int getCoresPerCPU() {
        int maxCores = 1;
        for (VisualizerCPU cpu : this.m_cpus) {
            int cores = cpu.getCoreCount();
            if (cores <= maxCores) continue;
            maxCores = cores;
        }
        return maxCores;
    }

    public List<VisualizerThread> getThreads() {
        return this.m_threads;
    }

    public List<VisualizerThread> getThreadsForProcess(int processId) {
        ArrayList<VisualizerThread> result = null;
        for (VisualizerThread thread : this.m_threads) {
            if (thread.getPID() != processId) continue;
            if (result == null) {
                result = new ArrayList<VisualizerThread>();
            }
            result.add(thread);
        }
        return result;
    }

    public VisualizerThread getThread(int threadId) {
        VisualizerThread result = null;
        for (VisualizerThread thread : this.m_threads) {
            if (thread.getGDBTID() != threadId) continue;
            result = thread;
            break;
        }
        return result;
    }

    public VisualizerThread addThread(VisualizerThread thread) {
        this.m_threads.add(thread);
        return thread;
    }

    public void removeThread(VisualizerThread thread) {
        this.m_threads.remove(thread);
    }

    public void removeThread(int threadId) {
        Iterator<VisualizerThread> itr = this.m_threads.iterator();
        while (itr.hasNext()) {
            VisualizerThread thread = itr.next();
            if (thread.getGDBTID() != threadId) continue;
            itr.remove();
            break;
        }
    }

    public void markThreadExited(int threadId) {
        if (this.m_keepExitedThreads) {
            VisualizerThread thread = this.getThread(threadId);
            thread.setState(VisualizerExecutionState.EXITED);
            thread.setLocationInfo((String)null);
        } else {
            this.removeThread(threadId);
        }
    }
}

