/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for Procedure API.
 * <p>
 *     A Procedure is a single argument lambda which has no return argument.
 * <p>
 *     This package contains the following interfaces:
 *     <ul>
 *         <li>
 *              {@link org.eclipse.collections.api.block.procedure.Procedure} - a single argument lambda which has no return argument.
 *         </li>
 *         <li>
 *              {@link org.eclipse.collections.api.block.procedure.Procedure2} - a two argument Procedure. Used by forEachWith() methods and for MapIterate.forEachKeyValue().
 *         </li>
 *     </ul>
 */
package org.eclipse.collections.api.block.procedure;
