/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.common.navigator.nodes.EClassesNode;
import org.eclipse.graphiti.examples.common.navigator.nodes.base.IContainerNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class GFEmfTreeContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Viewer viewer;
    private Map<IProject, EClassesNode> projectToEClassesNode = new HashMap<IProject, EClassesNode>();

    public GFEmfTreeContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainerNode) {
            IContainerNode icn = (IContainerNode)parentElement;
            return icn.getChildren();
        }
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.graphiti.examples.examplesnature")) {
                    EClassesNode node = this.projectToEClassesNode.get(project);
                    if (node == null) {
                        node = new EClassesNode(project, project, this.viewer);
                        this.projectToEClassesNode.put(project, node);
                    }
                    return new Object[]{node};
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof EObject) {
            EObject eObject = (EObject)parentElement;
            return eObject.eContents().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IContainerNode) {
            IContainerNode icn = (IContainerNode)element;
            return icn.hasChildren();
        }
        if (element instanceof EObject) {
            return !((EObject)element).eContents().isEmpty();
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource == null) {
                        return false;
                    }
                    switch (resource.getType()) {
                        case 8: {
                            return true;
                        }
                        case 4: {
                            IProject p = (IProject)resource;
                            try {
                                boolean hasNature = p.hasNature("org.eclipse.graphiti.examples.examplesnature");
                                return hasNature;
                            }
                            catch (CoreException hasNature) {
                                return false;
                            }
                        }
                        case 2: {
                            return true;
                        }
                        case 1: {
                            final IFile file = (IFile)resource;
                            if (file.getName().endsWith(".diagram") || file.getName().equals("Predefined.data")) {
                                UIJob job = new UIJob("Update Viewer"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (GFEmfTreeContentProvider.this.viewer != null && !GFEmfTreeContentProvider.this.viewer.getControl().isDisposed()) {
                                            EClassesNode classesNode = (EClassesNode)GFEmfTreeContentProvider.this.projectToEClassesNode.get(file.getProject());
                                            if (GFEmfTreeContentProvider.this.viewer instanceof StructuredViewer && classesNode != null) {
                                                ((StructuredViewer)GFEmfTreeContentProvider.this.viewer).refresh((Object)classesNode, true);
                                            } else {
                                                GFEmfTreeContentProvider.this.viewer.refresh();
                                            }
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setSystem(true);
                                job.schedule();
                            }
                            return false;
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException e1) {
            return;
        }
    }
}

