/*******************************************************************************
 * Copyright (c) 2001, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jem.internal.proxy.core;
/*


 */


/**
 * Interface to an integer bean proxy.
 * Creation date: (2/6/00 8:52:42 AM)
 * @author: Joe Winchester
 */
public interface INumberBeanProxy extends IBeanProxy {
/**
 * Return the primitive byte value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
byte byteValue();
/**
 * Return the primitive double value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
double doubleValue();
/**
 * Return the primitive float value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
float floatValue();
/**
 * Return the primitive int value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
int intValue();
/**
 * Return the primitive long value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
long longValue();
/**
 * Return the value as a Number.
 * Creation date: (2/6/00 8:52:59 AM)
 */
Number numberValue();
/**
 * Return the primitive short value of the proxied Number
 * Creation date: (2/6/00 8:52:59 AM)
 */
short shortValue();
}
