/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.java;

import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.NullJpaValidator;

public interface JavaConverter
extends Converter {
    @Override
    public JavaAttributeMapping getParent();

    public Annotation getConverterAnnotation();

    public static abstract class AbstractAdapter
    implements Adapter {
        @Override
        public JavaConverter buildConverter(JavaAttributeMapping parent, JpaFactory factory) {
            Annotation annotation = this.getConverterAnnotation(parent.getResourceAttribute());
            return annotation == null ? null : this.buildConverter(annotation, parent, factory);
        }

        protected abstract String getAnnotationName();

        @Override
        public Annotation getConverterAnnotation(JavaResourceAttribute attribute) {
            return attribute.getAnnotation(this.getAnnotationName());
        }

        @Override
        public JavaConverter buildNewConverter(JavaAttributeMapping parent, JpaFactory factory) {
            return this.buildConverter(this.buildConverterAnnotationIfNecessary(parent.getResourceAttribute()), parent, factory);
        }

        protected Annotation buildConverterAnnotationIfNecessary(JavaResourceAttribute attribute) {
            Annotation annotation = this.getConverterAnnotation(attribute);
            return annotation != null ? annotation : this.buildConverterAnnotation(attribute);
        }

        protected Annotation buildConverterAnnotation(JavaResourceAttribute attribute) {
            return attribute.addAnnotation(this.getAnnotationName());
        }

        @Override
        public void removeConverterAnnotation(JavaResourceAttribute attribute) {
            if (attribute.getAnnotation(this.getAnnotationName()) != null) {
                attribute.removeAnnotation(this.getAnnotationName());
            }
        }

        protected ParentAdapter buildConverterParentAdapter(JavaAttributeMapping parent) {
            return new ConverterParentAdapter(parent);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)ClassNameTools.simpleName((String)this.getAnnotationName()));
        }

        public static class ConverterParentAdapter
        implements ParentAdapter {
            private final JavaAttributeMapping parent;

            public ConverterParentAdapter(JavaAttributeMapping parent) {
                this.parent = parent;
            }

            @Override
            public JavaAttributeMapping getConverterParent() {
                return this.parent;
            }

            @Override
            public JpaValidator buildValidator(Converter converter) {
                return NullJpaValidator.instance();
            }
        }
    }

    public static interface Adapter {
        public Class<? extends Converter> getConverterType();

        public JavaConverter buildConverter(JavaAttributeMapping var1, JpaFactory var2);

        public Annotation getConverterAnnotation(JavaResourceAttribute var1);

        public JavaConverter buildConverter(Annotation var1, JavaAttributeMapping var2, JpaFactory var3);

        public JavaConverter buildNewConverter(JavaAttributeMapping var1, JpaFactory var2);

        public void removeConverterAnnotation(JavaResourceAttribute var1);
    }

    public static interface ParentAdapter
    extends Converter.ParentAdapter<JavaAttributeMapping> {
    }
}

