/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaNonEmbeddableTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ReadOnlyAnnotation;

public class EclipseLinkJavaReadOnly
extends AbstractJavaContextModel<EclipseLinkJavaNonEmbeddableTypeMapping>
implements EclipseLinkReadOnly {
    protected Boolean specifiedReadOnly = this.buildSpecifiedReadOnly();

    public EclipseLinkJavaReadOnly(EclipseLinkJavaNonEmbeddableTypeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedReadOnly_(this.buildSpecifiedReadOnly());
    }

    @Override
    public boolean isReadOnly() {
        return this.specifiedReadOnly != null ? this.specifiedReadOnly.booleanValue() : this.isDefaultReadOnly();
    }

    @Override
    public Boolean getSpecifiedReadOnly() {
        return this.specifiedReadOnly;
    }

    @Override
    public void setSpecifiedReadOnly(Boolean readOnly) {
        Boolean bl = readOnly == null ? null : (readOnly = readOnly != false ? readOnly : null);
        if (ObjectTools.notEquals((Object)readOnly, (Object)this.specifiedReadOnly)) {
            ReadOnlyAnnotation annotation = this.getReadOnlyAnnotation();
            if (readOnly != null) {
                if (annotation == null) {
                    this.addReadOnlyAnnotation();
                }
            } else if (annotation != null) {
                this.removeReadOnlyAnnotation();
            }
            this.setSpecifiedReadOnly_(readOnly);
        }
    }

    protected void setSpecifiedReadOnly_(Boolean readOnly) {
        Boolean old = this.specifiedReadOnly;
        this.specifiedReadOnly = readOnly;
        this.firePropertyChanged("specifiedReadOnly", old, readOnly);
    }

    private Boolean buildSpecifiedReadOnly() {
        return this.getReadOnlyAnnotation() == null ? null : Boolean.TRUE;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }

    protected ReadOnlyAnnotation getReadOnlyAnnotation() {
        return (ReadOnlyAnnotation)this.getJavaResourceType().getAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void addReadOnlyAnnotation() {
        this.getJavaResourceType().addAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void removeReadOnlyAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getReadOnlyAnnotationName());
    }

    protected String getReadOnlyAnnotationName() {
        return "org.eclipse.persistence.annotations.ReadOnly";
    }

    protected EclipseLinkJavaNonEmbeddableTypeMapping getTypeMapping() {
        return (EclipseLinkJavaNonEmbeddableTypeMapping)this.parent;
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        ReadOnlyAnnotation annotation = this.getReadOnlyAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

