/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.version.Version;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.CacheManager;
import org.eclipse.m2e.pde.target.DependencyDepth;
import org.eclipse.m2e.pde.target.DependencyNodeGenerator;
import org.eclipse.m2e.pde.target.MavenFeaturePlugin;
import org.eclipse.m2e.pde.target.MavenPomFeatureModel;
import org.eclipse.m2e.pde.target.MavenSourceBundle;
import org.eclipse.m2e.pde.target.MavenTargetBundle;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetFeature;
import org.eclipse.m2e.pde.target.MavenTargetRepository;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.m2e.pde.target.TargetBundles;
import org.eclipse.m2e.pde.target.TemplateFeatureModel;
import org.eclipse.m2e.pde.target.WorkspaceArtifact;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;

public class MavenTargetLocation
extends AbstractBundleContainer {
    private static final ILog LOGGER = Platform.getLog(MavenTargetLocation.class);
    private static final String SOURCE_SUFFIX = ".source";
    private static final String NOT_A_FEATURE = "not_a_feature";
    public static final String ELEMENT_CLASSIFIER = "classifier";
    public static final String ELEMENT_TYPE = "type";
    public static final String ELEMENT_VERSION = "version";
    public static final String ELEMENT_ARTIFACT_ID = "artifactId";
    public static final String ELEMENT_GROUP_ID = "groupId";
    public static final String ELEMENT_INSTRUCTIONS = "instructions";
    public static final String ELEMENT_EXCLUDED = "exclude";
    public static final String ELEMENT_DEPENDENCY = "dependency";
    public static final String ELEMENT_DEPENDENCIES = "dependencies";
    public static final String ELEMENT_REPOSITORY = "repository";
    public static final String ELEMENT_REPOSITORY_ID = "id";
    public static final String ELEMENT_REPOSITORY_URL = "url";
    public static final String ELEMENT_REPOSITORIES = "repositories";
    public static final String ELEMENT_FEATURE = "feature";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_INSTRUCTIONS_REFERENCE = "reference";
    public static final String ATTRIBUTE_DEPENDENCY_DEPTH = "includeDependencyDepth";
    public static final String ATTRIBUTE_DEPENDENCY_SCOPES = "includeDependencyScopes";
    public static final String ATTRIBUTE_INCLUDE_SOURCE = "includeSource";
    public static final String ATTRIBUTE_MISSING_META_DATA = "missingManifest";
    public static final List<String> DEFAULT_DEPENDENCY_SCOPES = List.of("compile");
    public static final MissingMetadataMode DEFAULT_METADATA_MODE = MissingMetadataMode.GENERATE;
    public static final String DEFAULT_PACKAGE_TYPE = "jar";
    public static final String POM_PACKAGE_TYPE = "pom";
    public static final String DEPENDENCYNODE_PARENT = "dependencynode.parent";
    public static final String DEPENDENCYNODE_ROOT = "dependencynode.root";
    public static final DependencyDepth DEFAULT_INCLUDE_MODE = DependencyDepth.NONE;
    private final Collection<String> dependencyScopes;
    private final MissingMetadataMode metadataMode;
    private TargetBundles targetBundles;
    private final Set<String> excludedArtifacts = new HashSet<String>();
    private final Set<org.eclipse.aether.artifact.Artifact> failedArtifacts = new HashSet<org.eclipse.aether.artifact.Artifact>();
    private final Map<String, BNDInstructions> instructionsMap = new LinkedHashMap<String, BNDInstructions>();
    private final boolean includeSource;
    private final List<MavenTargetDependency> roots;
    private final List<MavenTargetRepository> extraRepositories;
    private final IFeature featureTemplate;
    private String label;
    private DependencyDepth dependencyDepth;

    public MavenTargetLocation(String label, Collection<MavenTargetDependency> rootDependecies, Collection<MavenTargetRepository> extraRepositories, MissingMetadataMode metadataMode, DependencyDepth dependencyDepth, Collection<String> dependencyScopes, boolean includeSource, Collection<BNDInstructions> instructions, Collection<String> excludes, IFeature featureTemplate) {
        this.label = label;
        this.dependencyDepth = dependencyDepth;
        this.featureTemplate = featureTemplate;
        this.roots = new ArrayList<MavenTargetDependency>(rootDependecies);
        this.extraRepositories = Collections.unmodifiableList(new ArrayList<MavenTargetRepository>(extraRepositories));
        this.metadataMode = metadataMode;
        this.dependencyScopes = dependencyScopes;
        this.includeSource = includeSource;
        for (BNDInstructions instr : instructions) {
            this.instructionsMap.put(instr.key(), instr);
        }
        this.excludedArtifacts.addAll(excludes);
        for (MavenTargetDependency root : this.roots) {
            root.bind(this);
        }
    }

    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return (TargetBundle[])this.resolveArtifacts(definition, monitor).stream().flatMap(tb -> tb.bundles()).filter(e -> !this.isExcluded((org.eclipse.aether.artifact.Artifact)e.getKey())).map(Map.Entry::getValue).toArray(TargetBundle[]::new);
    }

    private synchronized Optional<TargetBundles> resolveArtifacts(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (this.targetBundles == null && definition != null) {
            CacheManager cacheManager = CacheManager.forTargetHandle(definition.getHandle());
            TargetBundles bundles = new TargetBundles();
            IMaven maven = MavenPlugin.getMaven();
            List<ArtifactRepository> repositories = this.getAvailableArtifactRepositories(maven);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.roots.size() * 100));
            for (MavenTargetDependency root : this.roots) {
                this.resolveDependency(root, maven, repositories, bundles, cacheManager, (IProgressMonitor)subMonitor.split(100));
            }
            if (this.featureTemplate != null) {
                this.generateFeature(bundles, false);
                if (this.includeSource) {
                    this.generateFeature(bundles, true);
                }
            }
            Iterable models = bundles.features.stream().map(TargetFeature::getFeatureModel)::iterator;
            for (IModel model : models) {
                model.load();
            }
            if (subMonitor.isCanceled()) {
                return Optional.empty();
            }
            this.targetBundles = bundles;
        }
        return Optional.ofNullable(this.targetBundles);
    }

    public String getLabel() {
        return this.label;
    }

    private void generateFeature(TargetBundles bundles, boolean source) throws CoreException {
        Predicate<TargetBundle> bundleFilter = TargetBundle::isSourceBundle;
        TemplateFeatureModel featureModel = new TemplateFeatureModel(this.featureTemplate);
        featureModel.load();
        IFeature feature = featureModel.getFeature();
        if (source) {
            feature.setId(feature.getId() + SOURCE_SUFFIX);
            String featureLabel = feature.getLabel();
            if (featureLabel != null && !featureLabel.isBlank()) {
                feature.setLabel(featureLabel + " (source)");
            }
            Stream<IFeaturePlugin> nonSourcePlugins = Arrays.stream(feature.getPlugins()).filter(p -> !p.getId().endsWith(SOURCE_SUFFIX));
            feature.removePlugins((IFeaturePlugin[])nonSourcePlugins.toArray(IFeaturePlugin[]::new));
        } else {
            bundleFilter = Predicate.not(bundleFilter);
        }
        Iterable featurePlugins = bundles.bundles().filter(e -> !this.isExcluded((org.eclipse.aether.artifact.Artifact)e.getKey()) && !this.isIgnored((org.eclipse.aether.artifact.Artifact)e.getKey())).map(Map.Entry::getValue).filter(bundleFilter).sorted(Comparator.comparing(TargetBundle::getBundleInfo, Comparator.comparing(BundleInfo::getSymbolicName)))::iterator;
        for (TargetBundle targetBundle : featurePlugins) {
            feature.addPlugins(new IFeaturePlugin[]{new MavenFeaturePlugin(targetBundle, (IFeatureModel)featureModel)});
        }
        featureModel.makeReadOnly();
        bundles.features.add(new MavenTargetFeature((IFeatureModel)featureModel));
    }

    public List<MavenTargetRepository> getExtraRepositories() {
        return this.extraRepositories;
    }

    private org.eclipse.aether.artifact.Artifact resolveDependency(MavenTargetDependency root, IMaven maven, List<ArtifactRepository> repositories, TargetBundles targetBundles, CacheManager cacheManager, IProgressMonitor monitor) throws CoreException {
        Object artifact;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMavenProjectRegistry registry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade workspaceProject = registry.getMavenProject(root.getGroupId(), root.getArtifactId(), root.getVersion());
        if (workspaceProject != null && workspaceProject.getPackaging().equals(root.getType())) {
            MavenProject mavenProject = workspaceProject.getMavenProject((IProgressMonitor)subMonitor.split(80));
            artifact = new WorkspaceArtifact(RepositoryUtils.toArtifact((Artifact)mavenProject.getArtifact()), workspaceProject);
        } else {
            artifact = RepositoryUtils.toArtifact((Artifact)maven.resolve(root.getGroupId(), root.getArtifactId(), root.getVersion(), root.getType(), root.getClassifier(), repositories, (IProgressMonitor)subMonitor.split(80)));
        }
        if (artifact != null) {
            DependencyDepth depth = this.dependencyDepth;
            if (this.isPomType((org.eclipse.aether.artifact.Artifact)artifact) && depth == DependencyDepth.NONE) {
                depth = DependencyDepth.DIRECT;
            }
            SubMonitor split = subMonitor.split(20);
            if (depth == DependencyDepth.DIRECT || depth == DependencyDepth.INFINITE) {
                ICallable<PreorderNodeListGenerator> callable = DependencyNodeGenerator.create(root, artifact, depth, this.dependencyScopes, repositories, this);
                PreorderNodeListGenerator dependecies = workspaceProject == null ? (PreorderNodeListGenerator)maven.createExecutionContext().execute(callable, (IProgressMonitor)subMonitor) : (PreorderNodeListGenerator)registry.execute(workspaceProject, callable, (IProgressMonitor)subMonitor);
                List artifacts = dependecies.getArtifacts(true);
                split.setWorkRemaining(artifacts.size());
                for (org.eclipse.aether.artifact.Artifact a : artifacts) {
                    if (a.getFile() == null) continue;
                    this.addBundleForArtifact(a, cacheManager, maven, targetBundles, (IProgressMonitor)split.split(1));
                }
                targetBundles.dependencyNodes.put(root, dependecies.getNodes());
            } else {
                this.addBundleForArtifact((org.eclipse.aether.artifact.Artifact)artifact, cacheManager, maven, targetBundles, (IProgressMonitor)split);
            }
        }
        return artifact;
    }

    private boolean isPomType(org.eclipse.aether.artifact.Artifact artifact) {
        return POM_PACKAGE_TYPE.equals(artifact.getExtension());
    }

    private File getFeatureFile(org.eclipse.aether.artifact.Artifact artifact, CacheManager cacheManager) {
        File baseFile = artifact.getFile();
        if (baseFile == null) {
            return null;
        }
        if (baseFile.isDirectory()) {
            File featureFile = new File(baseFile, "feature.xml");
            return featureFile.exists() ? featureFile : null;
        }
        if (DEFAULT_PACKAGE_TYPE.equals(FilenameUtils.getExtension((String)baseFile.getName()))) {
            return this.unpackFeatureFile(artifact, cacheManager);
        }
        return null;
    }

    private File unpackFeatureFile(org.eclipse.aether.artifact.Artifact artifact, CacheManager cacheManager) {
        try {
            return cacheManager.accessArtifactFile(artifact, file -> {
                File featureFile = new File(file.getParentFile(), "feature.xml");
                if (featureFile.exists()) {
                    return featureFile;
                }
                File markerFile = new File(file.getParentFile(), NOT_A_FEATURE);
                if (markerFile.exists() && markerFile.lastModified() >= file.lastModified()) {
                    return null;
                }
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (JarFile jar = new JarFile(artifact.getFile());){
                        ZipEntry entry = jar.getEntry("feature.xml");
                        if (entry == null) {
                            FileUtils.touch((File)markerFile);
                            return null;
                        }
                        Files.copy(jar.getInputStream(entry), featureFile.toPath(), new CopyOption[0]);
                        return featureFile;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private void addBundleForArtifact(org.eclipse.aether.artifact.Artifact artifact, CacheManager cacheManager, IMaven maven, TargetBundles targetBundles, IProgressMonitor monitor) {
        File featureFile = this.getFeatureFile(artifact, cacheManager);
        if (this.isPomType(artifact)) {
            targetBundles.features.add(new MavenTargetFeature((IFeatureModel)new MavenPomFeatureModel(artifact, targetBundles, false)));
            if (this.includeSource) {
                targetBundles.features.add(new MavenTargetFeature((IFeatureModel)new MavenPomFeatureModel(artifact, targetBundles, true)));
            }
            return;
        }
        if (featureFile != null) {
            try {
                targetBundles.features.add(new TargetFeature(featureFile));
            }
            catch (CoreException e) {
                this.failedArtifacts.add(artifact);
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        MavenTargetBundle bundle = new MavenTargetBundle(artifact, this, monitor);
        IStatus status = bundle.getStatus();
        if (status.isOK()) {
            targetBundles.addBundle(artifact, bundle);
            if (this.includeSource) {
                try {
                    List<ArtifactRepository> repositories = this.getAvailableArtifactRepositories(maven);
                    org.eclipse.aether.artifact.Artifact sourceArtifact = RepositoryUtils.toArtifact((Artifact)maven.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getExtension(), "sources", repositories, (IProgressMonitor)new NullProgressMonitor()));
                    MavenSourceBundle sourceBundle = new MavenSourceBundle(bundle.getBundleInfo(), sourceArtifact, cacheManager);
                    targetBundles.addBundle(sourceArtifact, sourceBundle);
                    targetBundles.addSourceBundle(artifact, sourceBundle);
                }
                catch (Exception exception) {}
            }
        } else if (status.matches(8)) {
            targetBundles.ignoredArtifacts.add(artifact);
        } else {
            this.failedArtifacts.add(artifact);
            targetBundles.addBundle(artifact, bundle);
        }
    }

    BNDInstructions getInstructionsForArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        BNDInstructions bndInstructions = this.instructionsMap.get(MavenTargetLocation.getKey(artifact));
        if (bndInstructions == null) {
            bndInstructions = this.instructionsMap.get("");
        }
        return bndInstructions;
    }

    public MavenTargetLocation update(IProgressMonitor monitor) throws CoreException {
        ArrayList<MavenTargetDependency> latest = new ArrayList<MavenTargetDependency>();
        int updated = 0;
        for (MavenTargetDependency dependency : this.roots) {
            MavenTargetDependency result = this.update(dependency, monitor);
            latest.add(result);
            if (dependency.matches(result)) continue;
            ++updated;
        }
        if (updated == 0) {
            return null;
        }
        return new MavenTargetLocation(this.label, latest, this.extraRepositories, this.metadataMode, this.dependencyDepth, this.dependencyScopes, this.includeSource, this.instructionsMap.values(), this.excludedArtifacts, this.featureTemplate);
    }

    public MavenTargetDependency update(MavenTargetDependency source, IProgressMonitor monitor) throws CoreException {
        List<ArtifactRepository> repositories;
        List remoteRepositories;
        VersionRangeRequest request;
        DefaultArtifact artifact = new DefaultArtifact(source.getGroupId() + ":" + source.getArtifactId() + ":(0,]");
        IMaven maven = MavenPlugin.getMaven();
        final RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
        IMavenExecutionContext context = maven.createExecutionContext();
        VersionRangeResult result = (VersionRangeResult)context.execute((ICallable)new ICallable<VersionRangeResult>(request = new VersionRangeRequest((org.eclipse.aether.artifact.Artifact)artifact, remoteRepositories = RepositoryUtils.toRepos(repositories = this.getAvailableArtifactRepositories(maven)), null)){
            private final /* synthetic */ VersionRangeRequest val$request;
            {
                this.val$request = versionRangeRequest;
            }

            public VersionRangeResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                RepositorySystemSession session = context.getRepositorySession();
                try {
                    return repoSystem.resolveVersionRange(session, this.val$request);
                }
                catch (VersionRangeResolutionException e) {
                    throw new CoreException(Status.error((String)"Resolving latest version failed", (Throwable)e));
                }
            }
        }, monitor);
        Version highestVersion = result.getHighestVersion();
        if (highestVersion == null || highestVersion.toString().equals(source.getVersion())) {
            return source.copy();
        }
        return new MavenTargetDependency(source.getGroupId(), source.getArtifactId(), highestVersion.toString(), source.getType(), source.getClassifier());
    }

    List<ArtifactRepository> getAvailableArtifactRepositories(IMaven maven) throws CoreException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(maven.getArtifactRepositories());
        for (MavenTargetRepository repo : this.extraRepositories) {
            ArtifactRepository repository = maven.createArtifactRepository(repo.getId(), repo.getUrl());
            repositories.add(repository);
        }
        return repositories;
    }

    public List<MavenTargetDependency> getRoots() {
        return this.roots;
    }

    public IFeature getFeatureTemplate() {
        return this.featureTemplate;
    }

    public BNDInstructions getInstructions(org.eclipse.aether.artifact.Artifact artifact) {
        String key = MavenTargetLocation.getKey(artifact);
        BNDInstructions bnd = this.instructionsMap.get(key);
        if (bnd == null) {
            return new BNDInstructions(key, null);
        }
        return bnd;
    }

    private static String getKey(org.eclipse.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isBlank()) {
            key = key + ":" + classifier;
        }
        return key + ":" + artifact.getBaseVersion();
    }

    private static String getKeyWithoutClassifier(org.eclipse.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    List<DependencyNode> getDependencyNodes(MavenTargetDependency dependency) {
        TargetBundles bundles = this.targetBundles;
        if (bundles == null) {
            return Collections.emptyList();
        }
        return bundles.dependencyNodes.get((Object)dependency);
    }

    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return (TargetFeature[])this.resolveArtifacts(definition, monitor).stream().flatMap(tb -> tb.features.stream()).toArray(TargetFeature[]::new);
    }

    public String getType() {
        return "Maven";
    }

    public String getLocation(boolean resolve) throws CoreException {
        return System.getProperty("java.io.tmpdir");
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.roots, this.dependencyScopes, this.failedArtifacts, this.metadataMode});
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof MavenTargetLocation) {
            void other;
            MavenTargetLocation mavenTargetLocation = (MavenTargetLocation)((Object)object);
            MavenTargetLocation cfr_ignored_0 = (MavenTargetLocation)((Object)object);
            if (Objects.equals(this.roots, other.roots) && Objects.equals(this.dependencyScopes, other.dependencyScopes) && Objects.equals(this.failedArtifacts, other.failedArtifacts)) {
                return true;
            }
        }
        return false;
    }

    public boolean isIncludeSource() {
        return this.includeSource;
    }

    public String serialize() {
        StringBuilder xml = new StringBuilder();
        xml.append("<location");
        MavenTargetLocation.attribute(xml, ATTRIBUTE_LABEL, this.label);
        MavenTargetLocation.attribute(xml, ATTRIBUTE_MISSING_META_DATA, this.metadataMode.name().toLowerCase());
        MavenTargetLocation.attribute(xml, ATTRIBUTE_DEPENDENCY_SCOPES, this.dependencyScopes.stream().collect(Collectors.joining(",")));
        MavenTargetLocation.attribute(xml, ATTRIBUTE_DEPENDENCY_DEPTH, this.dependencyDepth.name().toLowerCase());
        MavenTargetLocation.attribute(xml, ATTRIBUTE_INCLUDE_SOURCE, this.includeSource ? "true" : "");
        MavenTargetLocation.attribute(xml, ELEMENT_TYPE, this.getType());
        xml.append(">");
        if (this.featureTemplate != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (PrintWriter writer = new PrintWriter((Writer)new StringBuilderWriter(xml));){
                this.featureTemplate.write("", writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (!this.roots.isEmpty()) {
            xml.append("<dependencies>");
            this.roots.stream().sorted(Comparator.comparing(MavenTargetDependency::getKey)).forEachOrdered(dependency -> {
                xml.append("<dependency>");
                MavenTargetLocation.element(xml, ELEMENT_GROUP_ID, dependency.getGroupId());
                MavenTargetLocation.element(xml, ELEMENT_ARTIFACT_ID, dependency.getArtifactId());
                MavenTargetLocation.element(xml, ELEMENT_VERSION, dependency.getVersion());
                MavenTargetLocation.element(xml, ELEMENT_TYPE, dependency.getType());
                MavenTargetLocation.element(xml, ELEMENT_CLASSIFIER, dependency.getClassifier());
                xml.append("</dependency>");
            });
            xml.append("</dependencies>");
        }
        if (!this.extraRepositories.isEmpty()) {
            xml.append("<repositories>");
            this.extraRepositories.stream().sorted(Comparator.comparing(RepositoryBase::getUrl)).forEachOrdered(repository -> {
                xml.append("<repository>");
                MavenTargetLocation.element(xml, ELEMENT_REPOSITORY_ID, repository.getId());
                MavenTargetLocation.element(xml, ELEMENT_REPOSITORY_URL, repository.getUrl());
                xml.append("</repository>");
            });
            xml.append("</repositories>");
        }
        this.instructionsMap.values().stream().filter(Predicate.not(BNDInstructions::isEmpty)).sorted(Comparator.comparing(BNDInstructions::key)).forEachOrdered(bnd -> {
            xml.append("<instructions");
            MavenTargetLocation.attribute(xml, ATTRIBUTE_INSTRUCTIONS_REFERENCE, bnd.key());
            xml.append("><![CDATA[\r\n");
            xml.append(bnd.instructions());
            xml.append("\r\n]]></instructions>");
        });
        this.excludedArtifacts.stream().sorted().forEachOrdered(ignored -> MavenTargetLocation.element(xml, ELEMENT_EXCLUDED, ignored));
        xml.append("</location>");
        return xml.toString();
    }

    private static void element(StringBuilder xml, String name, String value) {
        if (value != null && !value.isBlank()) {
            xml.append('<').append(name).append('>');
            xml.append(value);
            xml.append("</").append(name).append('>');
        }
    }

    private static void attribute(StringBuilder xml, String name, String value) {
        if (value != null && !value.isBlank()) {
            xml.append(' ').append(name).append('=').append('\"').append(value).append('\"');
        }
    }

    public MissingMetadataMode getMetadataMode() {
        if (this.metadataMode == null) {
            return DEFAULT_METADATA_MODE;
        }
        return this.metadataMode;
    }

    public void refresh() {
        this.targetBundles = null;
        this.clearResolutionStatus();
    }

    public Collection<String> getDependencyScopes() {
        return this.dependencyScopes.isEmpty() ? DEFAULT_DEPENDENCY_SCOPES : this.dependencyScopes;
    }

    public DependencyDepth getDependencyDepth() {
        return this.dependencyDepth;
    }

    public boolean isIgnored(org.eclipse.aether.artifact.Artifact artifact) {
        TargetBundles bundles = this.targetBundles;
        return bundles != null && bundles.ignoredArtifacts.contains(artifact);
    }

    public boolean isFailed(org.eclipse.aether.artifact.Artifact artifact) {
        return this.failedArtifacts.contains(artifact);
    }

    public boolean isExcluded(org.eclipse.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        return this.excludedArtifacts.contains(MavenTargetLocation.getKey(artifact)) || artifact.getClassifier() != null && this.excludedArtifacts.contains(MavenTargetLocation.getKeyWithoutClassifier(artifact));
    }

    public void setExcluded(org.eclipse.aether.artifact.Artifact artifact, boolean disabled) {
        if (disabled) {
            this.excludedArtifacts.add(MavenTargetLocation.getKey(artifact));
        } else {
            this.excludedArtifacts.remove(MavenTargetLocation.getKey(artifact));
        }
    }

    public MavenTargetBundle getMavenTargetBundle(org.eclipse.aether.artifact.Artifact artifact) {
        TargetBundles bundles = this.targetBundles;
        if (bundles != null) {
            return bundles.getMavenTargetBundle(artifact).orElse(null);
        }
        return null;
    }

    public MavenTargetBundle getMavenTargetBundle(MavenTargetDependency dependency) {
        TargetBundles bundles = this.targetBundles;
        if (bundles != null) {
            return bundles.getTargetBundle(dependency).orElse(null);
        }
        return null;
    }

    public org.eclipse.aether.artifact.Artifact lookupArtifact(File file) {
        TargetBundles bundles = this.targetBundles;
        if (bundles != null) {
            return bundles.getArtifact(file).orElse(null);
        }
        return null;
    }

    public Collection<String> getExcludes() {
        return Collections.unmodifiableSet(this.excludedArtifacts);
    }

    public Collection<BNDInstructions> getInstructions() {
        return Collections.unmodifiableCollection(this.instructionsMap.values());
    }

    public MavenTargetLocation withInstructions(Collection<BNDInstructions> instructions) {
        return new MavenTargetLocation(this.label, this.roots.stream().map(MavenTargetDependency::copy).toList(), this.extraRepositories, this.metadataMode, this.dependencyDepth, this.dependencyScopes, this.includeSource, instructions, this.excludedArtifacts, this.featureTemplate);
    }

    public MavenTargetLocation withoutRoot(MavenTargetDependency toRemove) {
        return new MavenTargetLocation(this.label, this.roots.stream().filter(root -> root != toRemove).map(root -> root.copy()).collect(Collectors.toList()), this.extraRepositories, this.metadataMode, this.dependencyDepth, this.dependencyScopes, this.includeSource, this.instructionsMap.values(), this.excludedArtifacts, this.featureTemplate);
    }
}

