/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.ui.wizard.project;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.ProjectIntegration;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public abstract class PdeProjectIntegrationImpl
implements ProjectIntegration {
    private PluginClassCodeGenerator fGenerator;

    private PluginFieldData toFieldData(NewProjectData projectData) {
        PluginFieldData fieldData = new PluginFieldData();
        fieldData.setClassname(projectData.getClassName());
        fieldData.setDoGenerateClass(projectData.isDoGenerateClass());
        fieldData.setExecutionEnvironment(projectData.getfExecutionEnv());
        fieldData.setName(projectData.getName());
        fieldData.setOutputFolderName(projectData.getOutFolderName());
        fieldData.setProvider(projectData.getProviderName());
        fieldData.setSourceFolderName(projectData.getSourceFolderName());
        fieldData.setVersion(projectData.getVersion());
        fieldData.setUIPlugin(false);
        return fieldData;
    }

    public void setupProject(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        try {
            if (data.isPlugin()) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                this.fGenerator = new PluginClassCodeGenerator(project, data.getClassName(), this.toFieldData(data), false);
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)subMonitor.split(1));
                this.createManifest(project, data, (IProgressMonitor)subMonitor.split(1));
                this.createPluginXml(project, data, (IProgressMonitor)subMonitor.split(1));
                this.createBuildProperties(project, data, (IProgressMonitor)subMonitor.split(1));
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private IPluginReference[] getDependencies() {
        if (this.fGenerator == null) {
            return new IPluginReference[0];
        }
        return this.fGenerator.getDependencies();
    }

    protected void generateTopLevelPluginClass(IProgressMonitor monitor) throws CoreException {
        this.fGenerator.generate(monitor);
    }

    private void createManifest(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            String requiredEnv;
            IPluginReference[] dependencies;
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(serviceReference);
            IBundleProjectDescription description = service.getDescription(project);
            description.setBundleName(data.getName());
            description.setSymbolicName(data.getID());
            description.setBundleVersion(new Version(data.getVersion()));
            if (data.isDoGenerateClass() && !data.getClassName().isEmpty()) {
                description.setActivator(data.getClassName());
            }
            if (!data.getProviderName().isEmpty()) {
                description.setBundleVendor(data.getProviderName());
            }
            if ((dependencies = this.getDependencies()).length > 0) {
                ArrayList<IRequiredBundleDescription> requiredBundles = new ArrayList<IRequiredBundleDescription>();
                IPluginReference[] iPluginReferenceArray = dependencies;
                int n = dependencies.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginReference pluginReference = iPluginReferenceArray[n2];
                    requiredBundles.add(service.newRequiredBundle(pluginReference.getId(), new VersionRange(pluginReference.getVersion()), false, false));
                    ++n2;
                }
                description.setRequiredBundles(requiredBundles.toArray(new IRequiredBundleDescription[0]));
            }
            if (data.isCreateJava() && (requiredEnv = this.getRequiredExecutionEnv(data.getfExecutionEnv())) != null) {
                description.setExecutionEnvironments(new String[]{requiredEnv});
            }
            description.setActivationPolicy("lazy");
            description.setSingleton(true);
            description.apply((IProgressMonitor)subMonitor);
            context.ungetService(serviceReference);
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private void createBuildProperties(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            IFile buildProperties = PDEProject.getBuildProperties((IProject)project);
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            buildModel.load();
            buildModel.setEditable(true);
            if (data.isCreateJava()) {
                IPath sourceFolder = this.asBinIncludesFolder(this.getFolder(project, data.getSourceFolderName(), (IProgressMonitor)subMonitor.split(1)));
                IPath outFolder = this.asBinIncludesFolder(this.getFolder(project, data.getOutFolderName(), (IProgressMonitor)subMonitor.split(1)));
                IBuildEntry sourceEntry = buildModel.getFactory().createEntry("source..");
                sourceEntry.addToken(sourceFolder.toString());
                buildModel.getBuild().add(sourceEntry);
                IBuildEntry outputEntry = buildModel.getFactory().createEntry("output..");
                outputEntry.addToken(outFolder.toString());
                buildModel.getBuild().add(outputEntry);
            }
            IBuildEntry binIncludesEntry = buildModel.getBuild().getEntry("bin.includes");
            if (data.isCreateJava()) {
                binIncludesEntry.addToken(".");
            }
            IContainer qvtContainer = this.getFolder(project, data.getQVTSourceFolderName(), (IProgressMonitor)subMonitor.split(1));
            IPath qvtFolder = this.asBinIncludesFolder(qvtContainer);
            if (!project.equals((Object)qvtContainer) || !data.isCreateJava()) {
                binIncludesEntry.addToken(qvtFolder.toString());
            }
            binIncludesEntry.addToken(PDEProject.getPluginXml((IProject)project).getProjectRelativePath().toString());
            buildModel.save();
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private void createPluginXml(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        try {
            IFile pluginXml = PDEProject.getPluginXml((IProject)project);
            WorkspacePluginModel pluginModel = new WorkspacePluginModel(pluginXml, false);
            pluginModel.load();
            pluginModel.setEditable(true);
            IPluginExtension pluginExtension = pluginModel.createExtension();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.qvt.oml.runtime.qvtTransformationContainer");
            pluginExtension.setPoint(extensionPoint.getUniqueIdentifier());
            IPluginElement element = pluginModel.createElement((IPluginObject)pluginExtension);
            element.setName("sourceContainer");
            element.setAttribute("path", data.getQVTSourceFolderName());
            pluginExtension.add((IPluginObject)element);
            pluginModel.getExtensions().add(pluginExtension);
            pluginModel.save();
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private IPath asBinIncludesFolder(IContainer container) {
        if (container.equals((Object)container.getProject())) {
            return new Path(".");
        }
        IPath result = container.getProjectRelativePath();
        while (result.hasTrailingSeparator()) {
            result = result.removeTrailingSeparator();
        }
        return result.addTrailingSeparator();
    }

    protected IContainer getFolder(IProject project, String folderName, IProgressMonitor monitor) throws CoreException {
        try {
            if (folderName == null || folderName.trim().length() == 0) {
                IProject iProject = project;
                return iProject;
            }
            IFolder folder = project.getFolder(folderName);
            if (!folder.exists()) {
                this.createFolder(folder, monitor);
            }
            IFolder iFolder = folder;
            return iFolder;
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    protected void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        CoreUtility.createFolder((IFolder)folder);
    }
}

