/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.ui.AvatarLabel;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IssueSummaryPart
extends AbstractTaskEditorPart {
    public static final int AVATAR_SIZE = 48;
    private AbstractAttributeEditor summaryEditor;
    private String reporterAvatarId;
    private String assigneeAvatarId;

    public IssueSummaryPart(String reporterAvatarId, String assigneeAvatarId) {
        this.setPartName("Summary");
        this.reporterAvatarId = reporterAvatarId;
        this.assigneeAvatarId = assigneeAvatarId;
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute) {
        this.addAttribute(composite, toolkit, attribute, 6);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent) {
        this.addAttribute(composite, toolkit, attribute, indent, true);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent, boolean showLabel) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor == null) {
            return;
        }
        editor.setReadOnly(true);
        editor.setDecorationEnabled(false);
        if (showLabel) {
            editor.createLabelControl(composite, toolkit);
            GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(indent, 0).applyTo((Control)editor.getLabelControl());
        }
        if (this.isAttribute(attribute, "task.common.date.modified") && editor instanceof DateAttributeEditor) {
            ((DateAttributeEditor)editor).setShowTime(true);
        }
        editor.createControl(composite, toolkit);
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
    }

    private boolean isAttribute(TaskAttribute attribute, String id) {
        return attribute.getId().equals(attribute.getTaskData().getAttributeMapper().mapToRepositoryKey(attribute.getParentAttribute(), id));
    }

    private void addSummaryText(Composite composite, FormToolkit toolkit) {
        TaskAttribute summaryAttrib = this.getTaskData().getRoot().getMappedAttribute("task.common.summary");
        this.summaryEditor = this.createAttributeEditor(summaryAttrib);
        if (this.summaryEditor == null) {
            return;
        }
        if (summaryAttrib.getMetaData().isReadOnly()) {
            this.summaryEditor.setReadOnly(true);
        }
        if (this.summaryEditor instanceof RichTextAttributeEditor) {
            Composite roundedBorder = EditorUtil.createBorder((Composite)composite, (FormToolkit)toolkit, (!this.summaryEditor.isReadOnly() ? 1 : 0) != 0);
            this.summaryEditor.createControl(roundedBorder, toolkit);
            EditorUtil.setHeaderFontSizeAndStyle((Control)this.summaryEditor.getControl());
        } else {
            Composite border = toolkit.createComposite(composite);
            GridDataFactory.fillDefaults().align(4, 1).hint(300, -1).grab(true, false).applyTo((Control)border);
            GridLayoutFactory.fillDefaults().margins(1, 4).applyTo(border);
            this.summaryEditor.createControl(border, toolkit);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.summaryEditor.getControl());
            toolkit.paintBordersFor(border);
        }
        this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.summaryEditor);
    }

    private TaskAttribute getAttribute(IssueAttribute attribute) {
        return this.getAttribute(attribute.getMetadata().getId());
    }

    private TaskAttribute getAttribute(String id) {
        return this.getTaskData().getRoot().getAttribute(id);
    }

    private boolean addAvatarPart(Composite parent, FormToolkit toolkit, TaskAttribute avatarAttribute, IRepositoryPerson person) {
        if (avatarAttribute == null || avatarAttribute.getValue().length() == 0) {
            return false;
        }
        AvatarLabel label = new AvatarLabel(GitHubUi.getDefault().getStore(), person, avatarAttribute);
        label.create(parent, toolkit);
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        TaskAttribute reporter = this.getAttribute("task.common.user.reporter");
        if (reporter != null) {
            IRepositoryPerson person = this.getTaskData().getAttributeMapper().getRepositoryPerson(reporter);
            if (this.reporterAvatarId != null && this.addAvatarPart(composite, toolkit, this.getAttribute(this.reporterAvatarId), person)) {
                ++layout.numColumns;
            }
        }
        this.addSummaryText(composite, toolkit);
        TaskAttribute assignee = this.getAttribute(IssueAttribute.ASSIGNEE);
        if (assignee != null) {
            IRepositoryPerson person = this.getTaskData().getAttributeMapper().getRepositoryPerson(assignee);
            if (this.assigneeAvatarId != null && this.addAvatarPart(composite, toolkit, this.getAttribute(this.assigneeAvatarId), person)) {
                ++layout.numColumns;
            }
        }
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    private Composite createHeaderLayout(Composite composite, FormToolkit toolkit) {
        Composite headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headerComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)headerComposite);
        TaskAttribute root = this.getTaskData().getRoot();
        this.addAttribute(headerComposite, toolkit, root.getMappedAttribute("task.common.status"), 0);
        this.addAttribute(headerComposite, toolkit, root.getMappedAttribute("task.common.date.created"));
        this.addAttribute(headerComposite, toolkit, root.getMappedAttribute("task.common.date.modified"));
        layout.numColumns = headerComposite.getChildren().length;
        if (layout.numColumns == 0) {
            layout.numColumns = 1;
            toolkit.createLabel(headerComposite, " ");
        }
        return headerComposite;
    }

    private boolean needsHeader() {
        return !this.getTaskData().isNew();
    }

    public void setFocus() {
        if (this.summaryEditor != null) {
            this.summaryEditor.getControl().setFocus();
        }
    }
}

