/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions.evaluation;

import java.util.Collection;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.tests.fakes.conditions.FakeConditionPack;
import org.eclipse.passage.lic.api.tests.fakes.conditions.evaluation.FakePermission;
import org.junit.Assert;
import org.junit.Test;

public final class EmissionTest {
    @Test(expected=NullPointerException.class)
    public void conditionPackIsMandatory() {
        new Emission(null);
    }

    @Test(expected=RuntimeException.class)
    public void doesNotTolerateNullPermission() {
        new Emission((ConditionPack)new FakeConditionPack(), null);
    }

    @Test(expected=NullPointerException.class)
    public void doesNotTolerateNullPermissions() {
        new Emission((ConditionPack)new FakeConditionPack(), null);
    }

    @Test
    public void canSupplyNoPermissions() {
        Assert.assertTrue((boolean)new Emission((ConditionPack)new FakeConditionPack()).permissions().isEmpty());
    }

    @Test
    public void accumulateSinglePermission() {
        FakePermission fake = new FakePermission();
        Collection permissions = new Emission((ConditionPack)new FakeConditionPack(), (Permission)fake).permissions();
        Assert.assertTrue((permissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)fake, permissions.iterator().next());
    }
}

