/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.LinePiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.LinePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class LineIterator
implements PrintIterator {
    private final Device device;
    private final GC gc;
    final int orientation;
    final Point thickness;
    final RGB rgb;
    private boolean hasNext = true;

    LineIterator(LinePrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        this.orientation = print.orientation;
        this.rgb = print.rgb;
        Point dpi = device.getDPI();
        this.thickness = new Point(Math.max(1, (int)Math.round(print.thickness * (double)dpi.x / 72.0)), Math.max(1, (int)Math.round(print.thickness * (double)dpi.y / 72.0)));
    }

    LineIterator(LineIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.orientation = that.orientation;
        this.rgb = that.rgb;
        this.hasNext = that.hasNext;
        this.thickness = that.thickness;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    Point getSize(int width, int height) {
        return this.orientation == 512 ? new Point(this.thickness.x, height) : new Point(width, this.thickness.y);
    }

    @Override
    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        Point size = this.getSize(width, height);
        if (size.x > width || size.y > height) {
            return null;
        }
        LinePiece result = new LinePiece(this.device, size, this.rgb);
        this.hasNext = false;
        return result;
    }

    @Override
    public Point minimumSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    @Override
    public Point preferredSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    @Override
    public PrintIterator copy() {
        return new LineIterator(this);
    }
}

