/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.WidgetSpy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Sleak {
    org.eclipse.swt.widgets.List list;
    Canvas canvas;
    Button enableTracking;
    Button diff;
    Button stackTrace;
    Button saveAs;
    Button save;
    Combo diffType;
    Text text;
    String filterPath = "";
    String fileName = "sleakout";
    String selectedName;
    boolean incrementFileNames = true;
    boolean saveImages = true;
    int fileCount;
    List<ObjectWithError> oldObjects = new ArrayList<ObjectWithError>();
    List<ObjectWithError> objects = new ArrayList<ObjectWithError>();
    WidgetSpy.NonDisposedWidgetTracker nonDisposedWidgetTracker = new WidgetSpy.NonDisposedWidgetTracker();

    public static void main(String[] args) {
        DeviceData data = new DeviceData();
        data.tracking = true;
        Display display = new Display(data);
        Sleak sleak = new Sleak();
        Shell shell = new Shell(display);
        shell.setText("S-Leak");
        Point size = shell.getSize();
        shell.setSize(size.x / 2, size.y / 2);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        shell.setLayout((Layout)layout);
        sleak.create((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void create(Composite parent) {
        SashForm sash = new SashForm(parent, 65536);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        sash.setOrientation(256);
        sash.setVisible(true);
        Composite left = new Composite((Composite)sash, 0);
        left.setLayout((Layout)new GridLayout());
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite right = new Composite((Composite)sash, 0);
        right.setLayout((Layout)new GridLayout());
        sash.setWeights(new int[]{40, 60});
        this.canvas = new Canvas(right, 2048);
        this.canvas.addListener(9, event -> this.paintCanvas(event));
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true, 1, 10));
        this.text = new Text(right, 2816);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 1, 10));
        this.setVisible((Control)this.text, false);
        this.enableTracking = new Button(left, 32);
        this.enableTracking.setText("Enable resource tracking");
        this.enableTracking.setToolTipText("Enable Device resource tracking. Only resources allocated once enabled will be tracked. To track devices created before view is created, turn on tracing options, see https://www.eclipse.org/swt/tools.php");
        this.enableTracking.addListener(13, e -> this.toggleEnableTracking());
        this.enableTracking.setSelection(this.enableTracking.getDisplay().isTracking());
        this.enableTracking.setLayoutData((Object)new GridData(0, 0, false, false));
        Composite buttons = new Composite(left, 0);
        buttons.setLayout((Layout)new GridLayout(4, false));
        buttons.setLayoutData((Object)new GridData(4, 0, true, false));
        this.diff = new Button(buttons, 8);
        this.diff.setText("Snap && Diff");
        this.diff.addListener(13, event -> this.refreshDifference());
        GridData diffData = new GridData(4, 0, true, false);
        diffData.horizontalSpan = 2;
        this.diff.setLayoutData((Object)diffData);
        this.save = new Button(buttons, 8);
        this.save.setText("Save");
        this.save.setToolTipText("Saves to the previously selected file.");
        this.save.addListener(13, event -> this.saveToFile(false));
        this.save.setLayoutData((Object)new GridData(4, 0, false, false));
        this.saveAs = new Button(buttons, 8);
        this.saveAs.setText("Save As...");
        this.saveAs.setToolTipText("Saves the contents of the list to a file, optionally with the stack traces if selected.");
        this.saveAs.addListener(13, event -> this.saveToFile(true));
        this.saveAs.setLayoutData((Object)new GridData(4, 0, false, false));
        Composite checkboxAndCombo = new Composite(left, 0);
        checkboxAndCombo.setLayout((Layout)new GridLayout(2, false));
        checkboxAndCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.diffType = new Combo(checkboxAndCombo, 32);
        this.diffType.add("Object identity");
        this.diffType.add("Creator class and line");
        this.diffType.add("Creator class");
        this.diffType.select(0);
        this.diffType.setLayoutData((Object)new GridData(0, 0, false, false));
        this.stackTrace = new Button(checkboxAndCombo, 32);
        this.stackTrace.setText("Show Stack");
        this.stackTrace.addListener(13, e -> this.toggleStackTrace());
        this.stackTrace.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.list = new org.eclipse.swt.widgets.List(left, 2560);
        this.list.addListener(13, event -> this.refreshObject());
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackTrace.setSelection(false);
        this.filterNonDisposedWidgetTypes();
    }

    private void toggleEnableTracking() {
        Display display;
        boolean tracking = (display = this.enableTracking.getDisplay()).isTracking();
        display.setTracking(!tracking);
        this.setWidgetTrackingEnabled(tracking);
    }

    void refreshLabel(List<ObjectWithError> createdObjects, List<ObjectWithError> deletedObjects) {
        Function<ObjectWithError, String> classifier = o -> o.object.getClass().getSimpleName();
        Map<String, Long> deleted = deletedObjects.stream().collect(Collectors.groupingBy(classifier, Collectors.counting()));
        Map<String, Long> created = createdObjects.stream().collect(Collectors.groupingBy(classifier, Collectors.counting()));
        StringBuilder sb = new StringBuilder();
        Stream deletedAndCreated = Stream.concat(deleted.keySet().stream(), created.keySet().stream());
        deletedAndCreated.distinct().sorted().forEach(type -> Sleak.addCounts(sb, type, (Long)deleted.get(type), (Long)created.get(type)));
        String description = sb.length() > 0 ? sb.toString() : "0 object(s)";
        this.list.setToolTipText(description);
    }

    static void addCounts(StringBuilder string, String type, Long deleted, Long created) {
        if (deleted != null || created != null) {
            if (deleted != null) {
                string.append("-" + String.valueOf(deleted));
                if (created != null) {
                    string.append(" / ");
                }
            }
            if (created != null) {
                string.append(created);
            }
            string.append(" " + type + "(s)\n");
        }
    }

    void refreshDifference() {
        Display display = this.canvas.getDisplay();
        DeviceData info = this.getDeviceData(display);
        boolean hasOldData = !this.oldObjects.isEmpty();
        ArrayList<ObjectWithError> old = new ArrayList<ObjectWithError>(this.oldObjects);
        ArrayList<ObjectWithError> disposed = new ArrayList<ObjectWithError>();
        ArrayList<ObjectWithError> created = new ArrayList<ObjectWithError>();
        List<ObjectWithError> same = Sleak.collectNewObjects(info, old, disposed, created);
        List<ObjectWithError> nonDisposedWidgets = this.getNonDisposedWidgets();
        created.addAll(nonDisposedWidgets);
        this.resetNonDisposedWidgets();
        if (this.diffType.getSelectionIndex() > 0) {
            old.removeAll(same);
            if (!old.isEmpty()) {
                Iterator createdIter = created.iterator();
                block0: while (createdIter.hasNext()) {
                    ObjectWithError createdObj = (ObjectWithError)createdIter.next();
                    StackTraceElement stack = createdObj.getCreator();
                    for (ObjectWithError oldObj : old) {
                        if (!this.creatorEquals(stack, oldObj.getCreator())) continue;
                        createdIter.remove();
                        continue block0;
                    }
                }
            }
        }
        this.objects.clear();
        this.objects.addAll(created);
        this.oldObjects.clear();
        this.oldObjects.addAll(same);
        this.oldObjects.addAll(created);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        if (hasOldData) {
            for (ObjectWithError object : created) {
                this.list.add(object.object.toString());
            }
        }
        if (hasOldData) {
            this.refreshLabel(created, disposed);
        } else {
            this.refreshLabel(Collections.emptyList(), Collections.emptyList());
        }
    }

    private static List<ObjectWithError> collectNewObjects(DeviceData info, List<ObjectWithError> oldObjects, List<ObjectWithError> disposedObjects, List<ObjectWithError> createdObjects) {
        disposedObjects.addAll(oldObjects);
        ArrayList<ObjectWithError> sameObjects = new ArrayList<ObjectWithError>();
        int i = 0;
        while (i < info.objects.length) {
            boolean found = false;
            Iterator<ObjectWithError> oldObject = oldObjects.iterator();
            Object infoObject = info.objects[i];
            if (!(infoObject instanceof Color)) {
                while (oldObject.hasNext() && !found) {
                    ObjectWithError next = oldObject.next();
                    if (infoObject != next.object) continue;
                    sameObjects.add(next);
                    found = true;
                }
                if (!found) {
                    createdObjects.add(new ObjectWithError(infoObject, info.errors[i]));
                }
            }
            ++i;
        }
        disposedObjects.removeAll(sameObjects);
        return sameObjects;
    }

    private DeviceData getDeviceData(Display display) {
        DeviceData info = display.getDeviceData();
        if (!info.tracking) {
            Shell shell = this.canvas.getShell();
            MessageBox dialog = new MessageBox(shell, 200);
            dialog.setText(shell.getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation\nWould you like to enable tracking now for future created resources?");
            if (64 == dialog.open()) {
                this.enableTracking.setSelection(true);
                this.toggleEnableTracking();
            }
        }
        return info;
    }

    boolean creatorEquals(StackTraceElement first, StackTraceElement second) {
        switch (this.diffType.getSelectionIndex()) {
            case 1: {
                return first.equals(second);
            }
            case 2: {
                return first.getClassName().equals(second.getClassName());
            }
        }
        throw new IllegalArgumentException();
    }

    private void saveToFile(boolean prompt) {
        Throwable msg;
        if (prompt || this.selectedName == null) {
            FileDialog dialog = new FileDialog(this.saveAs.getShell(), 8192);
            dialog.setFilterPath(this.filterPath);
            dialog.setFileName(this.fileName);
            dialog.setOverwrite(true);
            this.selectedName = dialog.open();
            this.fileCount = 0;
            if (this.selectedName == null) {
                return;
            }
            this.filterPath = dialog.getFilterPath();
            this.fileName = dialog.getFileName();
            msg = new MessageBox(this.saveAs.getShell(), 196);
            msg.setText("Append incrementing file counter?");
            msg.setMessage("Append an incrementing file count to the file name on each save, starting at 000?");
            this.incrementFileNames = msg.open() == 64;
            msg = new MessageBox(this.saveAs.getShell(), 196);
            msg.setText("Save images for each resource?");
            msg.setMessage("Save an image (png) for each resource?");
            this.saveImages = msg.open() == 64;
        }
        String fileName = this.selectedName;
        if (this.incrementFileNames) {
            fileName = String.format("%s_%03d", fileName, this.fileCount++);
        }
        try {
            msg = null;
            Object var4_6 = null;
            try (PrintWriter file = new PrintWriter(new FileOutputStream(fileName));){
                int i = 0;
                for (ObjectWithError o : this.objects) {
                    Object object = o.object;
                    Error error = o.error;
                    file.print(object.toString());
                    if (this.saveImages) {
                        String suffix = String.format("%05d.png", i++);
                        String pngName = String.format("%s_%s", fileName, suffix);
                        Image image = new Image((Device)this.saveAs.getDisplay(), 100, 100);
                        try {
                            GC gc = new GC((Drawable)image);
                            try {
                                this.draw(gc, object);
                            }
                            finally {
                                gc.dispose();
                            }
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{image.getImageData()};
                            loader.save(pngName, 5);
                        }
                        finally {
                            image.dispose();
                        }
                        file.print(" -> ");
                        file.print(suffix);
                    }
                    file.println();
                    if (!this.stackTrace.getSelection()) continue;
                    error.printStackTrace(file);
                    System.out.println();
                }
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (IOException e1) {
            MessageBox msg2 = new MessageBox(this.saveAs.getShell(), 33);
            msg2.setText("Failed to save");
            msg2.setMessage("Failed to save S-Leak file.\n" + e1.getMessage());
            msg2.open();
        }
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.canvas.getParent().layout();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        GC gc = event.gc;
        Object object = this.objects.get((int)index).object;
        this.draw(gc, object);
    }

    void draw(GC gc, Object object) {
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gc.setFont((Font)object);
            Object string = "";
            String lf = this.text.getLineDelimiter();
            FontData[] fontDataArray = gc.getFont().getFontData();
            int n = fontDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                Object style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = (String)style + "ITALIC";
                    }
                }
                string = (String)string + data.getName() + " " + data.getHeight() + " " + (String)style + lf;
                ++n2;
            }
            gc.drawString((String)string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                return;
            }
            gc.drawImage((Image)object, 0, 0);
            return;
        }
        if (object instanceof Path) {
            if (((Path)object).isDisposed()) {
                return;
            }
            gc.drawPath((Path)object);
            return;
        }
        if (object instanceof Pattern) {
            if (((Pattern)object).isDisposed()) {
                return;
            }
            gc.setBackgroundPattern((Pattern)object);
            gc.fillRectangle(this.canvas.getClientArea());
            gc.setBackgroundPattern(null);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof TextLayout) {
            if (((TextLayout)object).isDisposed()) {
                return;
            }
            ((TextLayout)object).draw(gc, 0, 0);
            return;
        }
        if (object instanceof Transform) {
            if (((Transform)object).isDisposed()) {
                return;
            }
            String string = ((Transform)object).toString();
            gc.drawString(string, 0, 0);
            return;
        }
    }

    void refreshObject() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.stackTrace.getSelection()) {
            this.text.setText(this.objects.get(index).getStack());
            this.setVisible((Control)this.text, true);
            this.setVisible((Control)this.canvas, false);
            this.text.getParent().layout();
        } else {
            this.setVisible((Control)this.canvas, true);
            this.setVisible((Control)this.text, false);
            this.canvas.redraw();
        }
    }

    private void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    private void filterNonDisposedWidgetTypes() {
        List<Class> trackedTypes = Arrays.asList(new Class[0]);
        this.nonDisposedWidgetTracker.setTrackedTypes(trackedTypes);
    }

    private void setWidgetTrackingEnabled(boolean tracking) {
        this.nonDisposedWidgetTracker.setTrackingEnabled(tracking);
    }

    private List<ObjectWithError> getNonDisposedWidgets() {
        ArrayList<ObjectWithError> nonDisposedWidgets = new ArrayList<ObjectWithError>();
        this.nonDisposedWidgetTracker.getNonDisposedWidgets().forEach((w, e) -> {
            boolean bl = nonDisposedWidgets.add(new ObjectWithError(w, (Error)e));
        });
        return nonDisposedWidgets;
    }

    private void resetNonDisposedWidgets() {
        this.nonDisposedWidgetTracker.startTracking();
    }

    private static final class ObjectWithError {
        final Object object;
        final Error error;
        String stack;
        StackTraceElement creator;

        ObjectWithError(Object o, Error e) {
            this.object = o;
            this.error = e;
        }

        StackTraceElement getCreator() {
            if (this.creator == null) {
                String objectType = this.object.getClass().getName();
                Iterator<StackTraceElement> stack = Arrays.asList(this.error.getStackTrace()).iterator();
                while (stack.hasNext()) {
                    StackTraceElement element = stack.next();
                    if (!element.getClassName().equals(objectType) || !element.getMethodName().equals("<init>")) continue;
                    this.creator = stack.hasNext() ? stack.next() : null;
                    break;
                }
            }
            return this.creator;
        }

        String getStack() {
            if (this.stack == null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream s = new PrintStream(stream);
                this.error.printStackTrace(s);
                this.stack = stream.toString();
            }
            return this.stack;
        }
    }
}

