/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.jface.tooltips;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public class ClippedCellToolTip
extends DefaultToolTip {
    private final ColumnViewer fViewer;

    public static void enableFor(ColumnViewer viewer) {
        if ("win32".equals(Platform.getOS())) {
            return;
        }
        new ClippedCellToolTip(viewer, 2);
    }

    protected ClippedCellToolTip(ColumnViewer viewer, int style) {
        super(viewer.getControl(), style, false);
        this.fViewer = viewer;
    }

    protected Object getToolTipArea(Event event) {
        return this.fViewer.getCell(new Point(event.x, event.y));
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (!super.shouldCreateToolTip(event)) {
            return false;
        }
        ColumnViewer viewer = this.fViewer;
        Point point = new Point(event.x, event.y);
        ViewerCell cell = viewer.getCell(point);
        if (cell == null) {
            return false;
        }
        String text = cell.getText();
        Rectangle cellBounds = cell.getBounds();
        Rectangle textBounds = cell.getTextBounds();
        int maxWidth = textBounds != null ? textBounds.width : cellBounds.width;
        GC gc = new GC((Drawable)viewer.getControl());
        gc.setFont(cell.getFont());
        int width = gc.textExtent((String)text).x;
        gc.dispose();
        if (width <= maxWidth) {
            int cellMargin = cellBounds.x + width + 4;
            Rectangle viewerBounds = viewer.getControl().getBounds();
            int viewerMargin = viewerBounds.x + viewerBounds.width - 4;
            ScrollBar vsb = null;
            if (viewer instanceof TableViewer) {
                vsb = ((TableViewer)viewer).getTable().getVerticalBar();
            } else if (viewer instanceof TreeViewer) {
                vsb = ((TreeViewer)viewer).getTree().getVerticalBar();
            }
            if (vsb != null && vsb.isVisible()) {
                viewerMargin -= vsb.getSize().x;
            }
            if (cellMargin <= viewerMargin) {
                return false;
            }
        }
        this.setText(this.wrapText(text));
        return true;
    }

    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
        if (event != null && event.widget != this.fViewer.getControl()) {
            this.fViewer.getControl().setFocus();
        }
    }

    private String wrapText(String tooltipText) {
        StringBuilder buf = new StringBuilder();
        int maxCol = 80;
        int col = 0;
        int wordIdx = 0;
        int breakIdx = 0;
        int i = 0;
        while (i < tooltipText.length()) {
            char c = tooltipText.charAt(i);
            if (col >= 80 && c != '\n') {
                if (breakIdx == wordIdx) {
                    if (wordIdx > 0) {
                        buf.append('\n');
                    }
                    buf.append(tooltipText.substring(wordIdx, i));
                    col = i - wordIdx;
                    wordIdx = i;
                } else {
                    buf.append(tooltipText.substring(wordIdx, i));
                    wordIdx = breakIdx = i;
                }
            }
            switch (c) {
                case ' ': {
                    buf.append(tooltipText.substring(wordIdx, i));
                    buf.append(c);
                    ++col;
                    wordIdx = breakIdx = i + 1;
                    break;
                }
                case '\n': {
                    buf.append(tooltipText.substring(wordIdx, i));
                    buf.append(c);
                    col = 0;
                    wordIdx = breakIdx = i + 1;
                    break;
                }
                default: {
                    ++col;
                }
            }
            ++i;
        }
        buf.append(tooltipText.substring(wordIdx, i));
        return buf.toString();
    }
}

