/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EntityType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EClassifier Constraint</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl#getTransitive <em>Transitive</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.EClassifierConstraintImpl#getVar <em>Var</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EClassifierConstraintImpl extends ConstraintImpl implements EClassifierConstraint
{
	/**
	 * The default value of the '{@link #getTransitive() <em>Transitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransitive()
	 * @generated
	 * @ordered
	 */
	protected static final ClosureType TRANSITIVE_EDEFAULT = ClosureType.ORIGINAL;

	/**
	 * The cached value of the '{@link #getTransitive() <em>Transitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransitive()
	 * @generated
	 * @ordered
	 */
	protected ClosureType transitive = TRANSITIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected EntityType type;

	/**
	 * The cached value of the '{@link #getVar() <em>Var</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVar()
	 * @generated
	 * @ordered
	 */
	protected VariableReference var;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClassifierConstraintImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return PatternLanguagePackage.Literals.ECLASSIFIER_CONSTRAINT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClosureType getTransitive()
	{
		return transitive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTransitive(ClosureType newTransitive)
	{
		ClosureType oldTransitive = transitive;
		transitive = newTransitive == null ? TRANSITIVE_EDEFAULT : newTransitive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE, oldTransitive, transitive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntityType getType()
	{
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetType(EntityType newType, NotificationChain msgs)
	{
		EntityType oldType = type;
		type = newType;
		if (eNotificationRequired())
		{
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE, oldType, newType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(EntityType newType)
	{
		if (newType != type)
		{
			NotificationChain msgs = null;
			if (type != null)
				msgs = ((InternalEObject)type).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE, null, msgs);
			if (newType != null)
				msgs = ((InternalEObject)newType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE, null, msgs);
			msgs = basicSetType(newType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE, newType, newType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public VariableReference getVar()
	{
		return var;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetVar(VariableReference newVar, NotificationChain msgs)
	{
		VariableReference oldVar = var;
		var = newVar;
		if (eNotificationRequired())
		{
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR, oldVar, newVar);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVar(VariableReference newVar)
	{
		if (newVar != var)
		{
			NotificationChain msgs = null;
			if (var != null)
				msgs = ((InternalEObject)var).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR, null, msgs);
			if (newVar != null)
				msgs = ((InternalEObject)newVar).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR, null, msgs);
			msgs = basicSetVar(newVar, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR, newVar, newVar));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString()
	{
		return org.eclipse.viatra.query.patternlanguage.emf.util.ASTStringProvider.INSTANCE.doSwitch(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE:
				return basicSetType(null, msgs);
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR:
				return basicSetVar(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE:
				return getTransitive();
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE:
				return getType();
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR:
				return getVar();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE:
				setTransitive((ClosureType)newValue);
				return;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE:
				setType((EntityType)newValue);
				return;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR:
				setVar((VariableReference)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE:
				setTransitive(TRANSITIVE_EDEFAULT);
				return;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE:
				setType((EntityType)null);
				return;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR:
				setVar((VariableReference)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE:
				return transitive != TRANSITIVE_EDEFAULT;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE:
				return type != null;
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR:
				return var != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass)
	{
		if (baseClass == CallableRelation.class)
		{
			switch (derivedFeatureID)
			{
				case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE: return PatternLanguagePackage.CALLABLE_RELATION__TRANSITIVE;
				default: return -1;
			}
		}
		if (baseClass == UnaryTypeConstraint.class)
		{
			switch (derivedFeatureID)
			{
				case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE: return PatternLanguagePackage.UNARY_TYPE_CONSTRAINT__TYPE;
				case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR: return PatternLanguagePackage.UNARY_TYPE_CONSTRAINT__VAR;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass)
	{
		if (baseClass == CallableRelation.class)
		{
			switch (baseFeatureID)
			{
				case PatternLanguagePackage.CALLABLE_RELATION__TRANSITIVE: return PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TRANSITIVE;
				default: return -1;
			}
		}
		if (baseClass == UnaryTypeConstraint.class)
		{
			switch (baseFeatureID)
			{
				case PatternLanguagePackage.UNARY_TYPE_CONSTRAINT__TYPE: return PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__TYPE;
				case PatternLanguagePackage.UNARY_TYPE_CONSTRAINT__VAR: return PatternLanguagePackage.ECLASSIFIER_CONSTRAINT__VAR;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //EClassifierConstraintImpl
