/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.nebula.pshelf;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.nebula.pshelf.PShelfItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public final class PShelfInfo
extends CompositeInfo {
    private final PShelfInfo m_this = this;
    private PShelfItemInfo m_selectedItem;

    public PShelfInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.manageSelectedItem();
    }

    public List<PShelfItemInfo> getItems() {
        return this.getChildren(PShelfItemInfo.class);
    }

    private void manageSelectedItem() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void childRemoveBefore(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (child == PShelfInfo.this.m_selectedItem) {
                    PShelfInfo.this.m_selectedItem = null;
                }
            }

            public void selecting(ObjectInfo object, boolean[] refreshFlag) throws Exception {
                if (object != null && PShelfInfo.this.m_this.isParentOf(object)) {
                    for (PShelfItemInfo item : PShelfInfo.this.getItems()) {
                        if (item != object && !item.isParentOf(object)) continue;
                        if (PShelfInfo.this.m_selectedItem == item) break;
                        PShelfInfo.this.m_selectedItem = item;
                        refreshFlag[0] = true;
                        break;
                    }
                }
            }
        });
    }

    protected void refresh_afterCreate() throws Exception {
        this.showSelectedItem();
        super.refresh_afterCreate();
    }

    private void showSelectedItem() throws Exception {
        List<PShelfItemInfo> items;
        if (this.m_selectedItem == null && !(items = this.getItems()).isEmpty()) {
            this.m_selectedItem = items.get(0);
        }
        if (this.m_selectedItem != null) {
            ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"setSelection(org.eclipse.nebula.widgets.pshelf.PShelfItem)", (Object[])new Object[]{this.m_selectedItem.getObject()});
        }
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        this.setItemsBounds();
    }

    private void setItemsBounds() throws Exception {
        Object[] itemObjects;
        int y1 = 0;
        int y2 = 0;
        Object[] objectArray = itemObjects = (Object[])ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getItems()", (Object[])new Object[0]);
        int n = itemObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object itemObject = objectArray[n2];
            this.setItemBounds(itemObject, y1, y2 += this.getItemHeight(itemObject));
            y1 = y2;
            ++n2;
        }
    }

    private void setItemBounds(Object itemObject, int y1, int y2) {
        for (PShelfItemInfo item : this.getItems()) {
            if (item.getObject() != itemObject) continue;
            Rectangle shelfBounds = this.getModelBounds();
            Rectangle itemBounds = new Rectangle(0, y1, shelfBounds.width, y2 - y1);
            item.setModelBounds(itemBounds);
        }
    }

    private int getItemHeight(Object itemObject) throws Exception {
        int itemHeaderHeight;
        int height = itemHeaderHeight = ReflectionUtils.getFieldInt((Object)this.getObject(), (String)"itemHeight");
        if (this.m_selectedItem != null && itemObject == this.m_selectedItem.getObject()) {
            Object bodyParent = ReflectionUtils.invokeMethod((Object)itemObject, (String)"getBodyParent()", (Object[])new Object[0]);
            Rectangle bounds = ControlSupport.getBounds((Object)bodyParent);
            height += bounds.height;
        }
        return height;
    }
}

