/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.layout.generic.AbstractPopupFigure;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridSelectionEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridHelper;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class GridSelectionEditPolicy<C extends IControlInfo>
extends AbstractGridSelectionEditPolicy {
    private final IGridLayoutInfo<C> m_layout;
    private final C m_component;
    private final GridHelper m_gridHelper = new GridHelper((GraphicalEditPolicy)this, false);

    public GridSelectionEditPolicy(IGridLayoutInfo<C> layout, C component) {
        super(component);
        this.m_layout = layout;
        this.m_component = component;
    }

    protected boolean isActiveLayout() {
        return this.m_layout.isActive();
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> handlesList = new ArrayList<Handle>();
        handlesList.add((Handle)this.createMoveHandle());
        handlesList.add(this.createSizeHandle(16, 0.25));
        handlesList.add(this.createSizeHandle(4, 0.25));
        handlesList.add(this.createSpanHandle(1, 0.25));
        handlesList.add(this.createSpanHandle(8, 0.25));
        handlesList.add(this.createSpanHandle(16, 0.75));
        handlesList.add(this.createSpanHandle(4, 0.75));
        return handlesList;
    }

    protected void showPrimarySelection() {
        super.showPrimarySelection();
        this.m_gridHelper.showGridFeedback();
    }

    protected void hideSelection() {
        this.m_gridHelper.eraseGridFeedback();
        super.hideSelection();
    }

    protected Figure createAlignmentFigure(IAbstractComponentInfo component, boolean horizontal) {
        IEditPartViewer viewer = this.getHost().getViewer();
        try {
            final IGridDataInfo constraints = this.m_layout.getGridData2((IControlInfo)component);
            if (horizontal) {
                return new AbstractPopupFigure(viewer, 9, 5){

                    protected ImageDescriptor getImageDescriptor() {
                        return constraints.getSmallAlignmentImageDescriptor(true);
                    }

                    protected void fillMenu(IMenuManager manager) {
                        constraints.fillHorizontalAlignmentMenu(manager);
                    }
                };
            }
            return new AbstractPopupFigure(viewer, 5, 9){

                protected ImageDescriptor getImageDescriptor() {
                    return constraints.getSmallAlignmentImageDescriptor(false);
                }

                protected void fillMenu(IMenuManager manager) {
                    constraints.fillVerticalAlignmentMenu(manager);
                }
            };
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Command createSizeCommand(final boolean horizontal, final Dimension size) {
        return new EditCommand(this.m_object){

            protected void executeEdit() throws Exception {
                GridSelectionEditPolicy.this.m_layout.command_setSizeHint(GridSelectionEditPolicy.this.m_component, horizontal, size);
            }
        };
    }

    protected Command createSpanCommand(boolean horizontal, final Rectangle cells) {
        return new EditCommand(this.m_object){

            protected void executeEdit() throws Exception {
                GridSelectionEditPolicy.this.m_layout.command_setCells(GridSelectionEditPolicy.this.m_component, cells, true);
            }
        };
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (request instanceof KeyRequest && (keyRequest = (KeyRequest)request).isPressed()) {
            char c = keyRequest.getCharacter();
            if (c == 'o') {
                this.setFillBoth();
            }
            if (c == 'h') {
                this.flipGrab(true);
            } else if (c == 'l') {
                this.setAlignment(true, 16384);
            } else if (c == 'c') {
                this.setAlignment(true, 0x1000000);
            } else if (c == 'r') {
                this.setAlignment(true, 131072);
            } else if (c == 'f') {
                this.setAlignment(true, 4);
            }
            if (c == 'v') {
                this.flipGrab(false);
            } else if (c == 't') {
                this.setAlignment(false, 128);
            } else if (c == 'm') {
                this.setAlignment(false, 0x1000000);
            } else if (c == 'b') {
                this.setAlignment(false, 1024);
            } else if (c == 'F') {
                this.setAlignment(false, 4);
            }
        }
    }

    private void setFillBoth() {
        this.execute(new RunnableEx(){

            public void run() throws Exception {
                IGridDataInfo gridData = GridSelectionEditPolicy.this.m_layout.getGridData2(GridSelectionEditPolicy.this.m_component);
                gridData.setHorizontalGrab(true);
                gridData.setVerticalGrab(true);
                gridData.setHorizontalAlignment(4);
                gridData.setVerticalAlignment(4);
            }
        });
    }

    private void flipGrab(final boolean horizontal) {
        this.execute(new RunnableEx(){

            public void run() throws Exception {
                IGridDataInfo gridData = GridSelectionEditPolicy.this.m_layout.getGridData2(GridSelectionEditPolicy.this.m_component);
                if (horizontal) {
                    gridData.setHorizontalGrab(!gridData.getHorizontalGrab());
                } else {
                    gridData.setVerticalGrab(!gridData.getVerticalGrab());
                }
            }
        });
    }

    private void setAlignment(final boolean horizontal, final int alignment) {
        this.execute(new RunnableEx(){

            public void run() throws Exception {
                IGridDataInfo gridData = GridSelectionEditPolicy.this.m_layout.getGridData2(GridSelectionEditPolicy.this.m_component);
                if (horizontal) {
                    gridData.setHorizontalAlignment(alignment);
                } else {
                    gridData.setVerticalAlignment(alignment);
                }
            }
        });
    }

    private void execute(final RunnableEx runnable) {
        this.getHost().getViewer().getEditDomain().executeCommand((Command)new EditCommand(this.m_object){

            protected void executeEdit() throws Exception {
                runnable.run();
            }
        });
    }
}

