/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.editors;

import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.wst.jsdt.chromium.debug.ui.editors.JsCodeScanner;
import org.eclipse.wst.jsdt.chromium.debug.ui.editors.JsDebugTextHover;

public class JsSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String[] CONTENT_TYPES = new String[]{"__dftl_partition_content_type", "__jsdoc", "__js_multiline_comment", "__js_template_literal"};
    private final JsCodeScanner scanner = new JsCodeScanner();

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new JsDebugTextHover();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler pr = new PresentationReconciler();
        pr.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)this.scanner), "__dftl_partition_content_type");
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)new MultilineCommentScanner(this.scanner.getCommentAttribute())), "__js_multiline_comment");
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)new MultilineCommentScanner(this.scanner.getJsDocAttribute())), "__jsdoc");
        this.setDamagerRepairer(pr, new DefaultDamagerRepairer((ITokenScanner)new MultilineCommentScanner(this.scanner.getCommentAttribute())), "__js_template_literal");
        return pr;
    }

    private void setDamagerRepairer(PresentationReconciler pr, DefaultDamagerRepairer damagerRepairer, String tokenType) {
        pr.setDamager((IPresentationDamager)damagerRepairer, tokenType);
        pr.setRepairer((IPresentationRepairer)damagerRepairer, tokenType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    private static class MultilineCommentScanner
    extends BufferedRuleBasedScanner {
        public MultilineCommentScanner(TextAttribute attr) {
            this.setDefaultReturnToken((IToken)new Token((Object)attr));
        }
    }
}

