/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.FunctionValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ObjectValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.RefWithDisplayData;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.DataWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;

public abstract class SubpropertiesMirror {
    static final SubpropertiesMirror EMPTY = new SubpropertiesMirror(){

        @Override
        public List<? extends PropertyReference> getProperties() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends PropertyReference> getInternalProperties() {
            return Collections.emptyList();
        }

        @Override
        public Object getAdditionalPropertyData() {
            return EMPTY_OBJECT;
        }

        @Override
        public void reportAllProperties(ValueLoaderImpl valueLoader) {
        }
    };
    private static final Object EMPTY_OBJECT = new Object();

    public abstract List<? extends PropertyReference> getProperties();

    public abstract List<? extends PropertyReference> getInternalProperties();

    public abstract Object getAdditionalPropertyData();

    public abstract void reportAllProperties(ValueLoaderImpl var1);

    public static class FunctionValueBased
    extends JsonBased {
        private final FunctionValueHandle functionValueHandle;

        public FunctionValueBased(FunctionValueHandle functionValueHandle) {
            this.functionValueHandle = functionValueHandle;
        }

        @Override
        public FunctionValueHandle getAdditionalPropertyData() {
            return this.functionValueHandle;
        }

        @Override
        protected ObjectValueHandle getObjectValue() {
            return (ObjectValueHandle)this.functionValueHandle.getSuper();
        }
    }

    public static abstract class JsonBased
    extends SubpropertiesMirror {
        private List<? extends PropertyReference> properties = null;
        private List<? extends PropertyReference> internalProperties = null;

        @Override
        public synchronized List<? extends PropertyReference> getProperties() {
            if (this.properties == null) {
                this.properties = V8ProtocolUtil.extractObjectProperties(this.getObjectValue());
            }
            return this.properties;
        }

        @Override
        public synchronized List<? extends PropertyReference> getInternalProperties() {
            if (this.internalProperties == null) {
                this.internalProperties = V8ProtocolUtil.extractObjectInternalProperties(this.getObjectValue());
            }
            return this.internalProperties;
        }

        @Override
        public void reportAllProperties(ValueLoaderImpl valueLoader) {
            List<DataWithRef> refs = V8ProtocolUtil.extractAllPropertyRefs(this.getObjectValue());
            for (DataWithRef dataWithRef : refs) {
                RefWithDisplayData refWithDisplayData = dataWithRef.getWithDisplayData();
                if (refWithDisplayData == null) continue;
                valueLoader.addDisplayDataToMap(refWithDisplayData);
            }
        }

        protected abstract ObjectValueHandle getObjectValue();
    }

    static class ListBased
    extends SubpropertiesMirror {
        private final List<PropertyReference> list;

        ListBased(PropertyReference ... refs) {
            this(Collections.unmodifiableList(Arrays.asList(refs)));
        }

        ListBased(List<PropertyReference> refs) {
            this.list = refs;
        }

        @Override
        public List<? extends PropertyReference> getProperties() {
            return this.list;
        }

        @Override
        public List<? extends PropertyReference> getInternalProperties() {
            return Collections.emptyList();
        }

        @Override
        public Object getAdditionalPropertyData() {
            return EMPTY_OBJECT;
        }

        @Override
        public void reportAllProperties(ValueLoaderImpl valueLoader) {
            for (PropertyReference ref : this.list) {
                DataWithRef dataWithRef = ref.getValueObject();
                RefWithDisplayData refWithDisplayData = dataWithRef.getWithDisplayData();
                if (refWithDisplayData == null) continue;
                valueLoader.addDisplayDataToMap(refWithDisplayData);
            }
        }
    }

    public static class ObjectValueBased
    extends JsonBased {
        private final ObjectValueHandle objectValueHandle;

        public ObjectValueBased(ObjectValueHandle valueHandle) {
            this.objectValueHandle = valueHandle;
        }

        @Override
        public Object getAdditionalPropertyData() {
            return EMPTY_OBJECT;
        }

        @Override
        protected ObjectValueHandle getObjectValue() {
            return this.objectValueHandle;
        }
    }
}

