/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.AEADAlgorithmTags;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.util.Arrays;

public class AEADEncDataPacket
extends InputStreamPacket
implements AEADAlgorithmTags,
BCPGHeaderObject {
    public static final int VERSION_1 = 1;
    private final byte version;
    private final byte algorithm;
    private final byte aeadAlgorithm;
    private final byte chunkSize;
    private final byte[] iv;

    public AEADEncDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    public AEADEncDataPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(bCPGInputStream, 20, bl);
        this.version = (byte)bCPGInputStream.read();
        if (this.version != 1) {
            throw new UnsupportedPacketVersionException("wrong AEAD packet version: " + this.version);
        }
        this.algorithm = (byte)bCPGInputStream.read();
        this.aeadAlgorithm = (byte)bCPGInputStream.read();
        this.chunkSize = (byte)bCPGInputStream.read();
        this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
        bCPGInputStream.readFully(this.iv);
    }

    public AEADEncDataPacket(int n, int n2, int n3, byte[] byArray) {
        super(null, 20);
        this.version = 1;
        this.algorithm = (byte)n;
        this.aeadAlgorithm = (byte)n2;
        this.chunkSize = (byte)n3;
        this.iv = Arrays.clone((byte[])byArray);
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getAEADAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public byte[] getAAData() {
        return AEADEncDataPacket.createAAData(this.getVersion(), this.getAlgorithm(), this.getAEADAlgorithm(), this.getChunkSize());
    }

    public static byte[] createAAData(int n, int n2, int n3, int n4) {
        byte[] byArray = new byte[]{-44, (byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 & 0xFF)};
        return byArray;
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.write(1);
        bCPGOutputStream.write(this.getAlgorithm());
        bCPGOutputStream.write(this.getAEADAlgorithm());
        bCPGOutputStream.write(this.getChunkSize());
        bCPGOutputStream.write(this.iv);
    }

    public static int getIVLength(byte by) {
        return AEADUtils.getIVLength(by);
    }
}

