/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.ActivationConfig;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.mergers.JNDIRefsMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class MessageDrivenBeanMerger
extends ModelElementMerger {
    public MessageDrivenBeanMerger(MessageDrivenBean _baseBean, MessageDrivenBean _toMergeBean, int _kind) {
        super((JavaEEObject)_baseBean, (JavaEEObject)_toMergeBean, _kind);
    }

    private void mergeMessagingType(List<String> warnings) {
        if (this.getBaseBean().getMessagingType() == null) {
            this.getBaseBean().setMessagingType(this.getToMergeBean().getMessagingType());
        }
    }

    private void mergeActivationConfigurationProps(List<String> warnings) {
        ActivationConfig baseActConf = this.getBaseBean().getActivationConfig();
        if (baseActConf == null) {
            this.getBaseBean().setActivationConfig(this.getToMergeBean().getActivationConfig());
        } else {
            List baseActConfProps = baseActConf.getActivationConfigProperties();
            if (this.getToMergeBean().getActivationConfig() == null) {
                return;
            }
            List annotationProps = this.getToMergeBean().getActivationConfig().getActivationConfigProperties();
            for (Object object : annotationProps) {
                ActivationConfigProperty element = (ActivationConfigProperty)object;
                if (this.containsActivationConfigProperty(baseActConfProps, element)) continue;
                baseActConfProps.add(EcoreUtil.copy((EObject)((EObject)element)));
            }
        }
    }

    private boolean containsActivationConfigProperty(List properties, ActivationConfigProperty acp) {
        for (Object object : properties) {
            ActivationConfigProperty actConfProp = (ActivationConfigProperty)object;
            if (!actConfProp.getActivationConfigPropertyName().equals(acp.getActivationConfigPropertyName())) continue;
            return true;
        }
        return false;
    }

    MessageDrivenBean getBaseBean() {
        return (MessageDrivenBean)this.getBase();
    }

    MessageDrivenBean getToMergeBean() {
        return (MessageDrivenBean)this.getToMerge();
    }

    public List process() throws ModelException {
        ArrayList<String> warnings = new ArrayList<String>();
        if (this.getToMerge() == null) {
            return warnings;
        }
        String beanClass = this.getBaseBean().getEjbClass();
        if (beanClass == null) {
            beanClass = this.getToMergeBean().getEjbClass();
        }
        this.getBaseBean().setEjbClass(beanClass);
        this.mergeJNDIRefs(warnings);
        this.mergeTransactionType();
        this.mergeContainerTransactions(warnings);
        this.mergeSecurityIdentity(warnings);
        this.mergeTimeoutMethods(warnings);
        this.mergeMessagingType(warnings);
        this.mergeActivationConfigurationProps(warnings);
        return warnings;
    }

    private void mergeTransactionType() {
        TransactionType toMergeTransaction = this.getToMergeBean().getTransactionType();
        TransactionType baseTransaction = this.getBaseBean().getTransactionType();
        if (baseTransaction == null && toMergeTransaction != null) {
            this.getBaseBean().setTransactionType(toMergeTransaction);
        }
    }

    private void mergeJNDIRefs(List warnings) throws ModelException {
        JNDIRefsMerger jndiRefsMerger = new JNDIRefsMerger((JavaEEObject)this.getBaseBean(), (JavaEEObject)this.getToMergeBean(), this.getKind());
        warnings.addAll(jndiRefsMerger.process());
    }

    private void mergeSecurityIdentity(List warnings) throws ModelException {
        SecurityIdentityType baseSecId = this.getBaseBean().getSecurityIdentity();
        SecurityIdentityType toMergeSecId = this.getToMergeBean().getSecurityIdentity();
        if (baseSecId == null && toMergeSecId != null) {
            this.getBaseBean().setSecurityIdentity((SecurityIdentityType)EcoreUtil.copy((EObject)((EObject)toMergeSecId)));
        }
    }

    private void mergeContainerTransactions(List warnings) throws ModelException {
    }

    private void mergeTimeoutMethods(List warnings) throws ModelException {
        NamedMethodType timeoutMethod = this.getBaseBean().getTimeoutMethod();
        if (timeoutMethod == null && this.getToMergeBean().getTimeoutMethod() != null) {
            this.getBaseBean().setTimeoutMethod((NamedMethodType)EcoreUtil.copy((EObject)((EObject)this.getToMergeBean().getTimeoutMethod())));
        }
    }
}

