/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.internal.resource.ImmutableLifecycleListener;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewDefnAdapterFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public abstract class AbstractDTViewHandler
implements IDTViewHandler {
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private AbstractDTViewHandler parent;
    public static final String PATH_SEPARATOR = "/";

    @Override
    public abstract String calculateLocale(DTFacesContext var1) throws IDTViewHandler.ViewHandlerException;

    @Override
    public final DTUIViewRoot createView(DTFacesContext facesContext, String viewId) throws IDTViewHandler.ViewHandlerException {
        if (this._isDisposed.get()) {
            throw new IllegalStateException("View handler is disposed");
        }
        DTUIViewRoot viewRoot = this.internalCreateView(facesContext, viewId);
        if (viewRoot == null) {
            throw new IDTViewHandler.ViewHandlerException("Problem in createView", IDTViewHandler.ViewHandlerException.Cause.UNABLE_TO_CREATE_VIEW);
        }
        viewRoot.setViewId(viewId);
        DTUIViewRoot.VersionStamp versionStamp = this.createVersionStamp(facesContext, viewId);
        if (versionStamp == null) {
            throw new IDTViewHandler.ViewHandlerException(new Throwable("Bad version stamp detected"), IDTViewHandler.ViewHandlerException.Cause.BAD_VERSION_STAMP);
        }
        viewRoot.setVersionStamp(versionStamp);
        DTUIViewRoot.StalenessAdvisor advisor = this.createStalenessAdvisor(viewRoot, facesContext, viewId);
        if (advisor == null) {
            throw new IDTViewHandler.ViewHandlerException(new Throwable("Bad staleness advisor"), IDTViewHandler.ViewHandlerException.Cause.BAD_STALENESS_ADVISOR);
        }
        viewRoot.setStalenessAdvisor(advisor);
        viewRoot.setSubtreeProtected();
        this.registerView(viewRoot, facesContext, viewId);
        return viewRoot;
    }

    protected abstract DTUIViewRoot internalCreateView(DTFacesContext var1, String var2);

    @Override
    public abstract IResource getActionDefinition(DTFacesContext var1, String var2) throws IDTViewHandler.ViewHandlerException;

    @Override
    public abstract IPath getActionURL(DTFacesContext var1, IResource var2, IPath var3) throws IDTViewHandler.ViewHandlerException;

    @Override
    public abstract IPath getRelativeActionPath(DTFacesContext var1, String var2, String var3) throws IDTViewHandler.ViewHandlerException;

    @Override
    public abstract IViewDefnAdapterFactory getViewMetadataAdapterFactory(DTFacesContext var1) throws IDTViewHandler.ViewHandlerException;

    @Override
    public abstract boolean supportsViewDefinition(IFile var1);

    @Override
    public abstract void setLifecycleListener(ImmutableLifecycleListener var1);

    @Override
    public final void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this.doDispose();
        }
    }

    protected void doDispose() {
    }

    public AbstractDTViewHandler getParent() {
        return this.parent;
    }

    public void setParent(AbstractDTViewHandler parent) {
        this.parent = parent;
    }

    protected abstract DTUIViewRoot.VersionStamp createVersionStamp(DTFacesContext var1, String var2);

    protected abstract DTUIViewRoot.StalenessAdvisor createStalenessAdvisor(DTUIViewRoot var1, DTFacesContext var2, String var3);

    protected void registerView(DTUIViewRoot viewRoot, DTFacesContext context, String viewId) {
    }

    @Override
    public String getViewId(DTFacesContext context, IResource res) {
        Object strWebrootPath = "";
        IProject project = res.getProject();
        IPath path = res.getFullPath();
        IPath webContentPath = this.getWebContentPath(project);
        if (webContentPath != null && webContentPath.isPrefixOf(path)) {
            int start = path.matchingFirstSegments(webContentPath);
            String[] segments = path.segments();
            int i = start;
            int n = path.segmentCount();
            while (i < n) {
                strWebrootPath = (String)strWebrootPath + PATH_SEPARATOR + segments[i];
                ++i;
            }
        }
        return strWebrootPath;
    }

    private IPath getWebContentPath(IProject project) {
        IContainer container;
        IVirtualFolder folder;
        IVirtualComponent component;
        IPath path = null;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (folder = component.getRootFolder()) != null && (container = folder.getUnderlyingFolder()) != null) {
            path = container.getFullPath();
        }
        return path;
    }

    protected static final class NullStalenessAdvisor
    extends DTUIViewRoot.StalenessAdvisor {
        private static final long serialVersionUID = 5946420948320047613L;

        protected NullStalenessAdvisor() {
        }

        @Override
        public boolean isStale() {
            return false;
        }

        @Override
        public void addListener(DTUIViewRoot.StalenessListener listener) {
        }

        @Override
        public void removeListener(DTUIViewRoot.StalenessListener listener) {
        }

        @Override
        public boolean isAccessible() {
            return true;
        }
    }

    protected static final class NullViewRoot
    extends DTUIViewRoot {
        private static final long serialVersionUID = 1187035338610719171L;

        protected NullViewRoot() {
            super(null, null, new ComponentTypeInfo("", "", "", ""));
        }

        @Override
        public IAdaptable getServices() {
            return new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    return null;
                }
            };
        }

        @Override
        protected Map<String, ISymbol> doGetMapForScope(int scopeMask) {
            return Collections.emptyMap();
        }
    }

    protected static class TimeBasedVersionStamp
    extends DTUIViewRoot.VersionStamp {
        private static final long serialVersionUID = 5557828245936568977L;
        private final long timestamp = System.currentTimeMillis();
        private final long randomStamp = (long)(9.223372036854776E18 * Math.random());

        @Override
        public int hashCode() {
            return (int)(this.timestamp ^ this.randomStamp);
        }

        @Override
        protected boolean isEqual(DTUIViewRoot.VersionStamp other) {
            return other instanceof TimeBasedVersionStamp && this.timestamp == ((TimeBasedVersionStamp)other).timestamp && this.randomStamp == ((TimeBasedVersionStamp)other).randomStamp;
        }
    }
}

