/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;

public class EclipseMonitor
extends Monitor {
    private IProgressMonitor progressMonitor;
    private String taskName;

    public EclipseMonitor(IProgressMonitor progressMonitor, String taskName) {
        this.progressMonitor = progressMonitor;
        this.taskName = taskName;
    }

    public EclipseMonitor(IProgressMonitor progressMonitor) {
        this(progressMonitor, "");
    }

    public EclipseMonitor() {
        this((IProgressMonitor)new NullProgressMonitor(), "");
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public boolean isCanceled() {
        if (super.isCanceled()) {
            return true;
        }
        return this.progressMonitor.isCanceled();
    }

    @Override
    public OMMonitor begin(double totalWork) throws MonitorCanceledException {
        super.begin(totalWork);
        int eclipseWork = totalWork > 2.147483647E9 ? Integer.MAX_VALUE : (int)totalWork;
        this.progressMonitor.beginTask(this.taskName, eclipseWork);
        return this;
    }

    @Override
    public void worked(double work) throws MonitorCanceledException {
        super.worked(work);
        this.progressMonitor.internalWorked(work);
    }

    @Override
    public void done() {
        super.done();
        this.progressMonitor.done();
    }

    public static OMMonitor convert(IProgressMonitor progressMonitor) {
        return progressMonitor == null ? null : new EclipseMonitor(progressMonitor);
    }

    public static OMMonitor safe(IProgressMonitor progressMonitor) {
        return progressMonitor == null ? new Monitor() : new EclipseMonitor(progressMonitor);
    }

    public static class SynchronizedSubProgressMonitor
    extends SubProgressMonitor {
        public SynchronizedSubProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginTask(String name, int totalWork) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.beginTask(name, totalWork);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearBlocked() {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.clearBlocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void internalWorked(double work) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.internalWorked(work);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCanceled() {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                return super.isCanceled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBlocked(IStatus reason) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.setBlocked(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCanceled(boolean b) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.setCanceled(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTaskName(String name) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.setTaskName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void subTask(String name) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.subTask(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void worked(int work) {
            IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
            synchronized (iProgressMonitor) {
                super.worked(work);
            }
        }
    }
}

