/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.internal.ids.UnscopedId;

public class EnumerationLiteralIdImpl
extends UnscopedId
implements EnumerationLiteralId {
    protected final @NonNull EnumerationId parentId;

    private static int computeHashCode(@NonNull EnumerationId parentId, @NonNull String name) {
        return IdHash.createChildHash(parentId, name);
    }

    public EnumerationLiteralIdImpl(@NonNull EnumerationId parentId, @NonNull String name) {
        super(EnumerationLiteralIdImpl.computeHashCode(parentId, name), name);
        this.parentId = parentId;
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitEnumerationLiteralId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.parentId + "::" + this.name;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "Enumeration";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull EnumerationId getParentId() {
        return this.parentId;
    }

    public static class EnumerationLiteralIdSingletonScope
    extends AbstractSingletonScope<EnumerationLiteralId, String> {
        public @NonNull EnumerationLiteralId getSingleton(@NonNull EnumerationId parentId, @NonNull String value) {
            return this.getSingletonFor(new EnumerationLiteralIdValue(parentId, value));
        }
    }

    private static class EnumerationLiteralIdValue
    extends SingletonScope.AbstractKeyAndValue<EnumerationLiteralId> {
        private final @NonNull EnumerationId parentId;
        private final @NonNull String value;

        private EnumerationLiteralIdValue(@NonNull EnumerationId parentId, @NonNull String value) {
            super(EnumerationLiteralIdImpl.computeHashCode(parentId, value));
            this.parentId = parentId;
            this.value = value;
        }

        @Override
        public @NonNull EnumerationLiteralId createSingleton() {
            return new EnumerationLiteralIdImpl(this.parentId, this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof EnumerationLiteralIdImpl) {
                EnumerationLiteralIdImpl singleton = (EnumerationLiteralIdImpl)that;
                return singleton.getName().equals(this.value);
            }
            return false;
        }
    }
}

