/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.project.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Observable;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.job.CreateProjectJob;
import org.eclipse.php.composer.ui.wizard.AbstractWizardFirstPage;
import org.eclipse.php.composer.ui.wizard.AbstractWizardSecondPage;
import org.eclipse.php.composer.ui.wizard.project.template.Messages;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterChangedListener;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterItem;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterViewer;
import org.eclipse.php.composer.ui.wizard.project.template.PackageProjectWizardFirstPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PackageProjectWizardSecondPage
extends AbstractWizardSecondPage
implements IShellProvider,
PackageFilterChangedListener {
    private PackageFilterViewer filter;
    private boolean projectJobFailed = false;

    public PackageProjectWizardSecondPage(AbstractWizardFirstPage mainPage, String title) {
        super(mainPage, title);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filter.getControl().setFocus();
        if (this.filter.getSelectedPackage() == null || this.filter.getSelectedPackage().getSelectedVersion() == null) {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        this.filter = new PackageFilterViewer();
        this.filter.createControl(parent);
        this.filter.addChangeListener(this);
        this.filter.setMinimumHeight(400);
        this.setControl(this.filter.getControl());
        this.setPageComplete(false);
        this.setHelpContext(this.filter.getControl());
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected String getPageTitle() {
        return Messages.PackageProjectWizardSecondPage_Title;
    }

    @Override
    protected String getPageDescription() {
        return Messages.PackageProjectWizardSecondPage_Description;
    }

    @Override
    protected void beforeFinish(IProgressMonitor monitor) {
        PackageFilterItem filterItem = this.filter.getSelectedPackage();
        final CountDownLatch latch = new CountDownLatch(1);
        monitor.beginTask(Messages.PackageProjectWizardSecondPage_InitializingProjectTaskName, 2);
        monitor.worked(1);
        File file = new File(this.firstPage.getLocationURI());
        Path location = new Path(file.toString());
        if (this.firstPage.isInLocalServer()) {
            location = location.removeLastSegments(1);
        }
        CreateProjectJob projectJob = new CreateProjectJob((IPath)location, this.firstPage.nameGroup.getName(), filterItem.getPackage().getName(), filterItem.getSelectedVersion());
        projectJob.setJobListener(new CreateProjectJob.JobListener(){

            @Override
            public void jobStarted() {
                latch.countDown();
            }

            @Override
            public void jobFinished(String projectName) {
                latch.countDown();
                PackageProjectWizardSecondPage.this.refreshProject(projectName);
            }

            @Override
            public void jobFailed() {
                latch.countDown();
                PackageProjectWizardSecondPage.this.projectJobFailed = true;
            }
        });
        projectJob.schedule();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {}
        monitor.worked(1);
        if (this.projectJobFailed) {
            throw new OperationCanceledException();
        }
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) {
        try {
            try {
                PackageProjectWizardFirstPage page = (PackageProjectWizardFirstPage)this.firstPage;
                if (page.doesOverrideComposer()) {
                    monitor.beginTask(Messages.PackageProjectWizardSecondPage_UpdatingComposerJsonTaskName, 1);
                    ComposerPackage package1 = this.firstPage.getPackage();
                    IFile file = this.getProject().getFile((IPath)new Path("composer.json"));
                    if (file != null && file.exists()) {
                        ByteArrayInputStream is = new ByteArrayInputStream(package1.toJson().getBytes());
                        file.setContents((InputStream)is, 1, monitor);
                    }
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                monitor.worked(1);
            }
        }
        finally {
            monitor.worked(1);
        }
    }

    @Override
    public void filterChanged(PackageFilterItem item) {
        boolean canFinish = item != null && item.isChecked() && item.getSelectedVersion() != null;
        this.setPageComplete(canFinish);
    }

    protected void setHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.php.composer.ui.help_context_wizard_template_secondpage");
    }
}

