/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ValidationDecoration
extends LabelDecorator {
    public static final ImageDescriptor ERROR_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/error_co.gif");
    public static final ImageDescriptor WARNING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/warning_co.gif");
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>(1);
    private Map<Object, Integer> severityMap = new HashMap<Object, Integer>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        Integer severity;
        if (this.severityMap.containsKey(element) && ((severity = this.severityMap.get(element)) == 4 || severity == 2)) {
            ComposedImage img = this.decorateSeverity(image, severity);
            ComposedImageDescriptor descriptor = new ComposedImageDescriptor(img);
            return SiriusEditPlugin.getPlugin().getImage((ImageDescriptor)descriptor);
        }
        return image;
    }

    private ComposedImage decorateSeverity(Image image, Integer severity) {
        ArrayList<Image> images = new ArrayList<Image>(2);
        images.add(image);
        if (severity == 4) {
            images.add(SiriusEditPlugin.getPlugin().getImage(ERROR_OVERLAY_DESC));
        } else if (severity == 2) {
            images.add(SiriusEditPlugin.getPlugin().getImage(WARNING_OVERLAY_DESC));
        }
        ComposedImage ci = new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                ArrayList<ComposedImage.Point> results = new ArrayList<ComposedImage.Point>();
                results.add(new ComposedImage.Point());
                ComposedImage.Point overlay = new ComposedImage.Point();
                overlay.x = 0;
                overlay.y = 7;
                results.add(overlay);
                return results;
            }
        };
        return ci;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public String decorateText(String text, Object element, IDecorationContext context) {
        return text;
    }

    public void dispose() {
        this.listeners = new ArrayList<ILabelProviderListener>(1);
    }

    private void fireLabelEvent(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    private void notifyViewer(Map<Object, Integer> oldSeverityMap, Map<Object, Integer> newSeverityMap) {
        ArrayList<Object> changedObjects = new ArrayList<Object>();
        changedObjects.addAll(oldSeverityMap.keySet());
        changedObjects.addAll(newSeverityMap.keySet());
        this.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, changedObjects.toArray()));
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return true;
    }

    private static void processDiagnostic(Diagnostic diagnostic, Map<Object, Integer> severityMap) {
        if (diagnostic.getChildren().size() == 0 && diagnostic.getCode() == 0) {
            for (Object obj2 : severityMap.keySet()) {
                severityMap.put(obj2, 0);
            }
            return;
        }
        List dataEntries = diagnostic.getData();
        for (Object obj : dataEntries) {
            if (!(obj instanceof EObject)) continue;
            severityMap.put(obj, diagnostic.getSeverity());
        }
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            ValidationDecoration.processDiagnostic(childDiagnostic, severityMap);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void setDiagnostics(Diagnostic diagnostic) {
        Map<Object, Integer> oldSeverityMap = this.severityMap;
        ValidationDecoration.processDiagnostic(diagnostic, this.severityMap);
        this.notifyViewer(oldSeverityMap, this.severityMap);
    }
}

