/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.properties.BaseTitledSection;
import org.eclipse.tcf.te.launch.ui.tabs.refprojects.RefProjectsContentProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RefProjectsPropertiesSection
extends BaseTitledSection {
    private IReferencedProjectItem[] items;
    private TableViewer viewer;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Table table = this.getWidgetFactory().createTable(this.composite, 67586);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, -4);
        table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.ReferencedProjectsSection_name_column);
        column.setWidth(200);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new RefProjectsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileTransferLabelProvider());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof LaunchNode));
        ILaunchConfiguration node = ((LaunchNode)((Object)input)).getLaunchConfiguration();
        ArrayList<IReferencedProjectItem> list = new ArrayList<IReferencedProjectItem>();
        for (IReferencedProjectItem item : Arrays.asList(ReferencedProjectsPersistenceDelegate.getReferencedProjects((ILaunchConfiguration)node))) {
            if (!item.isEnabled()) continue;
            list.add(item);
        }
        this.items = list.toArray(new IReferencedProjectItem[list.size()]);
    }

    @Override
    public void refresh() {
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.items);
        }
    }

    @Override
    protected String getText() {
        return Messages.ReferencedProjectsSection_title;
    }

    protected static class FileTransferLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected FileTransferLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((IReferencedProjectItem)element).getProjectName();
                }
            }
            return "";
        }
    }
}

