/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;

public class StructuredRegionProcessor
extends DocumentRegionProcessor {
    private IModelLifecycleListener fLifeCycleListener = new ModelLifecycleListener();
    private IDocument fCurrentDoc = null;
    private IStructuredModel fCurrentModel = null;

    @Override
    protected DirtyRegion getOuterRegion(DirtyRegion root, DirtyRegion possible) {
        DirtyRegion outer = super.getOuterRegion(root, possible);
        if (outer == null && this.fCurrentDoc != null) {
            IStructuredModel sModel = null;
            try {
                sModel = this.getStructuredModelForRead(this.fCurrentDoc);
                if (sModel != null) {
                    IndexedRegion rootRegion = sModel.getIndexedRegion(root.getOffset());
                    IndexedRegion possRegion = sModel.getIndexedRegion(possible.getOffset());
                    if (rootRegion != null && possRegion != null) {
                        int possStart;
                        int rootStart = rootRegion.getStartOffset();
                        outer = rootStart <= (possStart = possRegion.getStartOffset()) ? this._getOuterRegion(root, possible, sModel, rootStart, possStart) : this._getOuterRegion(possible, root, sModel, possStart, rootStart);
                    }
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return outer;
    }

    private DirtyRegion _getOuterRegion(DirtyRegion region1, DirtyRegion region2, IStructuredModel sModel, int region1NodeStart, int region2NodeStart) {
        DirtyRegion outer = null;
        int region1NodeEnd = -1;
        int region2NodeEnd = -1;
        IndexedRegion region1EndNode = sModel.getIndexedRegion(region1.getOffset() + region1.getLength());
        if (region1EndNode == null) {
            outer = region1;
        } else {
            region1NodeEnd = region1EndNode.getEndOffset();
            IndexedRegion region2EndNode = sModel.getIndexedRegion(region2.getOffset() + region2.getLength());
            int n = region2NodeEnd = region2EndNode != null ? region2EndNode.getEndOffset() : this.getDocument().getLength();
            if (region1NodeEnd >= region2NodeEnd) {
                outer = region1;
            } else if (region1NodeStart == region2NodeStart && region2NodeEnd >= region1NodeEnd) {
                outer = region2;
            }
        }
        if (DEBUG) {
            if (outer != null) {
                System.out.println("checking if [" + region1NodeStart + ":" + region1NodeEnd + "] contains [" + region2NodeStart + ":" + region2NodeEnd + "] ... " + outer.toString());
            } else {
                System.out.println("checking if [" + region1NodeStart + ":" + region1NodeEnd + "] contains [" + region2NodeStart + ":" + region2NodeEnd + "] ... NO CONTAIN");
            }
        }
        return outer;
    }

    @Override
    protected String getContentType(IDocument doc) {
        if (this.fCurrentModel != null && doc == this.fCurrentModel.getStructuredDocument()) {
            return this.fCurrentModel.getContentTypeIdentifier();
        }
        String contentTypeId = null;
        IStructuredModel sModel = null;
        try {
            sModel = this.getStructuredModelForRead(doc);
            if (sModel != null) {
                contentTypeId = sModel.getContentTypeIdentifier();
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return contentTypeId;
    }

    private IStructuredModel getStructuredModelForRead(IDocument doc) {
        IStructuredModel sModel = null;
        if (doc != null && doc instanceof IStructuredDocument) {
            sModel = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)doc);
        }
        return sModel;
    }

    @Override
    protected void process(DirtyRegion dirtyRegion) {
        if (!this.isInstalled() || this.isInRewriteSession() || dirtyRegion == null || this.getDocument() == null) {
            return;
        }
        if (this.fCurrentDoc != null) {
            IStructuredModel sModel = null;
            try {
                sModel = this.getStructuredModelForRead(this.fCurrentDoc);
                if (sModel != null) {
                    int start = dirtyRegion.getOffset();
                    int end = start + dirtyRegion.getLength();
                    IndexedRegion irStart = sModel.getIndexedRegion(start);
                    IndexedRegion irEnd = sModel.getIndexedRegion(end);
                    if (irStart != null) {
                        start = Math.min(start, irStart.getStartOffset());
                    }
                    if (irEnd != null) {
                        end = Math.max(end, irEnd.getEndOffset());
                    }
                    super.process(this.createDirtyRegion(start, end - start, "__insert"));
                }
                super.process(dirtyRegion);
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        } else {
            super.process(dirtyRegion);
        }
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        this.setDocument(newDocument);
    }

    @Override
    public void setDocument(IDocument newDocument) {
        if (this.fCurrentModel != null) {
            this.fCurrentModel.removeModelLifecycleListener(this.fLifeCycleListener);
            this.fCurrentModel.releaseFromRead();
            this.fCurrentModel = null;
        }
        super.setDocument(newDocument);
        this.fCurrentDoc = newDocument;
        if (this.fCurrentDoc != null) {
            this.fCurrentModel = this.getStructuredModelForRead(this.fCurrentDoc);
            if (this.fCurrentModel != null) {
                this.fCurrentModel.addModelLifecycleListener(this.fLifeCycleListener);
            }
        }
    }

    class ModelLifecycleListener
    implements IModelLifecycleListener {
        IStructuredModel changing = null;

        ModelLifecycleListener() {
        }

        public void processPostModelEvent(ModelLifecycleEvent event) {
            if (event.getType() == 3) {
                if (this.changing != null && event.getModel() == this.changing) {
                    IStructuredDocument sDoc = event.getModel().getStructuredDocument();
                    if (DEBUG) {
                        System.out.println("======================================================");
                        System.out.println("StructuredRegionProcessor: DOCUMENT MODEL CHANGED TO: ");
                        System.out.println(sDoc.get());
                        System.out.println("======================================================");
                    }
                    StructuredRegionProcessor.this.setDocument((IDocument)sDoc);
                }
                this.changing = null;
            }
        }

        public void processPreModelEvent(ModelLifecycleEvent event) {
            if (StructuredRegionProcessor.this.fCurrentDoc != null && StructuredRegionProcessor.this.fCurrentModel != null && event.getType() == 3 && event.getModel() == StructuredRegionProcessor.this.fCurrentModel) {
                this.changing = event.getModel();
                StructuredRegionProcessor.this.flushDirtyRegionQueue();
            }
        }
    }
}

