/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.narcissus;

import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionCache {
    private final Map<String, List<Method>> methodNameToMethods = new HashMap<String, List<Method>>();
    private final Map<String, Field> fieldNameToField = new HashMap<String, Field>();

    public ReflectionCache(Class<?> cls) {
        for (Method method : Narcissus.enumerateMethods(cls)) {
            List<Method> methodsForName = this.methodNameToMethods.get(method.getName());
            if (methodsForName == null) {
                methodsForName = new ArrayList<Method>();
                this.methodNameToMethods.put(method.getName(), methodsForName);
            }
            methodsForName.add(method);
        }
        for (Field field : Narcissus.enumerateFields(cls)) {
            this.fieldNameToField.put(field.getName(), field);
        }
    }

    public ReflectionCache(String className) {
        this(Narcissus.findClass(className));
    }

    public Field getField(String fieldName) {
        return this.fieldNameToField.get(fieldName);
    }

    public List<Method> getMethods(String methodName) {
        return this.methodNameToMethods.get(methodName);
    }

    public Method getMethod(String methodName, Class<?> ... paramTypes) {
        List<Method> methods = this.getMethods(methodName);
        if (methods != null) {
            for (Method method : methods) {
                if (!Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }
}

